/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.inet.server.bean.InetCommandLoopPattern;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class InetDeviceCommandUtils {
    private static StringBuffer processBlock(String text, InetCommandLoopPattern loopPattern) {
        StringBuffer result = new StringBuffer();
        ArrayList<PatternItem> items = new ArrayList<PatternItem>(10);
        HashMap<String, Integer> letterMaxNumbers = new HashMap<String, Integer>();
        Pattern pattern = Pattern.compile("\\{([A-Z]+)(\\d+)\\}");
        Matcher m = pattern.matcher(text);
        while (m.find()) {
            String letter = m.group(1);
            int number = Utils.parseInt((String)m.group(2), (int)0);
            PatternItem item = new PatternItem();
            item.number = number;
            item.letter = letter;
            items.add(item);
            Integer maxNumber = (Integer)letterMaxNumbers.get(letter);
            if (maxNumber != null && maxNumber >= number) continue;
            letterMaxNumbers.put(letter, number);
        }
        int size = loopPattern.getObjects().size();
        for (int i = 0; i < size; ++i) {
            String addressText = new String(text);
            for (PatternItem item : items) {
                int number = i * ((Integer)letterMaxNumbers.get(item.letter) + 1) + item.number;
                addressText = addressText.replaceAll("\\{" + item.letter + item.number + "\\}", "{" + item.letter + number + "}");
            }
            String str = addressText;
            for (int j = 0; j < loopPattern.getReplacements().size(); ++j) {
                String key = loopPattern.getReplacements().get(j);
                String value = loopPattern.getObjects().get(i).get(j);
                str = str.replaceAll(key, value);
            }
            result.append(str);
        }
        return result;
    }

    public static final String generateCommands(String text, String template, List<String> addresses, Map<String, String> replacements, String optionConfig) {
        Pattern pattern = Pattern.compile(template, 32);
        return InetDeviceCommandUtils.generateCommands(text, pattern, addresses, replacements, optionConfig);
    }

    public static final String generateCommands(String text, Pattern pattern, List<String> addresses, Map<String, String> replacements, String optionConfig) {
        List<InetCommandLoopPattern> loops = InetDeviceCommandUtils.getAddresLoops(addresses);
        Matcher m = pattern.matcher(text);
        String result = "";
        if (m.find()) {
            result = m.group(1);
            result = InetDeviceCommandUtils.generateCommands(m.group(1), replacements, optionConfig, loops);
        }
        return result;
    }

    public static List<InetCommandLoopPattern> getAddresLoops(List<String> addresses) {
        ArrayList<String> replacements = new ArrayList<String>();
        replacements.add("\\{A\\}");
        ArrayList<List<String>> objects = new ArrayList<List<String>>();
        for (String address : addresses) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(address);
            objects.add(list);
        }
        ArrayList<InetCommandLoopPattern> loops = new ArrayList<InetCommandLoopPattern>();
        InetCommandLoopPattern p = new InetCommandLoopPattern();
        p.setLoopPatern("LOOP");
        p.setReplacements(replacements);
        p.setObjects(objects);
        loops.add(p);
        return loops;
    }

    public static final String generateCommands(String text, Map<String, String> replacements, String optionConfig, List<InetCommandLoopPattern> loops) {
        StringBuffer resultBuf = null;
        for (InetCommandLoopPattern loop : loops) {
            resultBuf = new StringBuffer();
            String loopPattern = "(<LOOP>.*?</LOOP>)?(.*?)<LOOP>(.*?)</LOOP>";
            loopPattern = loopPattern.replaceAll("LOOP", loop.getLoopPatern());
            Pattern pattern = Pattern.compile(loopPattern, 32);
            Matcher m = pattern.matcher(text);
            boolean find = false;
            while (m.find()) {
                find = true;
                String block = m.group(3);
                block = InetDeviceCommandUtils.processBlock(block, loop).toString();
                resultBuf.append(m.group(2));
                resultBuf.append(block);
            }
            if (find) {
                loopPattern = "(?:<LOOP>(?:.*)</LOOP>)(.*)\\z";
                Pattern pattern2 = Pattern.compile(loopPattern = loopPattern.replaceAll("LOOP", loop.getLoopPatern()), 32);
                m = pattern2.matcher(text);
                if (m.find()) {
                    resultBuf.append(m.group(1));
                }
            } else {
                resultBuf = new StringBuffer(text);
            }
            text = resultBuf.toString();
        }
        String result = resultBuf.toString();
        result = result.replaceAll("<ver 2\\.0/>", "");
        result = result.replaceAll("\r", "");
        result = result.replaceAll("\n\\s*\n", "\n");
        result = result.replaceAll("(\n){2,}", "\n");
        result = result.trim();
        optionConfig = optionConfig.replaceAll("\r", "\n");
        optionConfig = optionConfig.trim();
        Preferences setup = new Preferences(optionConfig, "\n");
        if (replacements == null) {
            replacements = new HashMap<String, String>();
        }
        for (Map.Entry entry : setup.entrySet()) {
            String key = "\\$\\{" + (String)entry.getKey() + "\\}";
            replacements.put(key, (String)entry.getValue());
        }
        if (replacements != null) {
            for (Map.Entry entry : replacements.entrySet()) {
                result = result.replaceAll((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return result.toString();
    }

    private static class PatternItem {
        public String letter;
        public int number;

        private PatternItem() {
        }
    }
}

