/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.client;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelButtonGroup;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.PeriodTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.organizer.client.OrganizerCreateTaskButton;
import ru.bitel.bgbilling.plugins.organizer.client.OrganizerRecordEditor;
import ru.bitel.bgbilling.plugins.organizer.client.bean.RecordInfo;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class OrganizerCurrentTasksPanel
extends BGUPanel {
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private CurrentTasksTableModel tableModel = new CurrentTasksTableModel();
    private BGControlPanelButtonGroup userFilter = new BGControlPanelButtonGroup();
    private BGControlPanelButtonGroup statusFilter = new BGControlPanelButtonGroup();
    private OrganizerRecordEditor editor = new OrganizerRecordEditor();

    public OrganizerCurrentTasksPanel() {
        this.editor.setVisible(false);
        this.editor.setParent(this);
    }

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add("\u041a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443").addActionListener(e -> this.gotoContract());
        table.setComponentPopupMenu(popupMenu);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        BGButton buttonSearch = new BGButton("\u041f\u043e\u0438\u0441\u043a");
        buttonSearch.addActionListener(e -> {
            this.pagePanel.init();
            this.performAction("refresh");
        });
        BGButton buttonReset = new BGButton("\u0421\u0431\u0440\u043e\u0441");
        buttonReset.addActionListener(e -> {
            this.pagePanel.init();
            this.performAction("refresh");
        });
        this.pagePanel.setKey(Utils.getDigest((String)((Object)((Object)this)).getClass().getName(), (String)"UTF-8"));
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(e -> {
            String name = e.getPropertyName();
            if (name != null && name.startsWith("to")) {
                this.performAction("refresh");
            }
        });
        filterPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        filterPanel.add((Component)new JLabel("\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.userFilter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)new JLabel("\u0421\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.statusFilter, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.recordCountLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 15), 0, 0));
        filterPanel.add((Component)this.pagePanel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.userFilter.addButton("\u0412\u0441\u0435", "all");
        this.userFilter.addButton("\u0422\u043e\u043b\u044c\u043a\u043e \u043c\u043e\u0438", "my");
        this.userFilter.setSelectedCommand("my");
        this.userFilter.addActionListener(e -> {
            this.pagePanel.init();
            this.performAction("refresh");
        });
        this.statusFilter.addButton("\u0412\u0441\u0435", "all");
        this.statusFilter.addButton("\u041a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044e", "current");
        this.statusFilter.addButton("\u041f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0435", "outofdate");
        this.statusFilter.setSelectedCommand("current");
        this.statusFilter.addActionListener(e -> {
            this.pagePanel.init();
            this.performAction("refresh");
        });
        mainPanel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    OrganizerCurrentTasksPanel.this.openEditor(false);
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                OrganizerCreateTaskButton button = (OrganizerCreateTaskButton)ClientSetup.getInstance().getObject(OrganizerCreateTaskButton.class.getName());
                if (button != null && button.isOpenEditor()) {
                    OrganizerCurrentTasksPanel.this.openEditor(button.getContractId(), button.getContractTitle());
                    button.setOpenEditor(false);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(mainPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 2), 0, 0));
        this.add((Component)((Object)this.editor), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void openEditor(int cid, String contract) {
        this.openEditor(true);
        if (cid > 0) {
            this.editor.setContractToField(cid, contract);
        }
    }

    private void openEditor(boolean clear) {
        Map rowMap = (Map)this.tableModel.getSelectedRow();
        if (clear || rowMap == null) {
            this.editor.initiate(new RecordInfo());
            this.editor.setVisible(true);
            return;
        }
        RecordInfo info = new RecordInfo();
        info.setId(rowMap.get("id").toString());
        info.setContractId((Integer)rowMap.get("cid"));
        info.setContractName(rowMap.get("contract").toString());
        info.setTitle(rowMap.get("title").toString());
        info.setComm(rowMap.get("comment").toString());
        info.setUser(rowMap.get("todo_uid").toString());
        info.setGroup(rowMap.get("todo_gid").toString());
        info.setPeriod((Period)rowMap.get("period"));
        this.editor.initiate(info);
        this.editor.setVisible(true);
    }

    private void gotoContract() {
        Integer contractId;
        Map rowMap = (Map)this.tableModel.getSelectedRow();
        if (rowMap != null && (contractId = (Integer)rowMap.get("cid")) != null && contractId > 0) {
            ClientUtils.openContract((int)contractId);
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            Request request = new Request();
            request.setModule("ru.bitel.bgbilling.plugins.organizer");
            request.setAction("GetCurrentTaskList");
            request.setAttribute("status", this.statusFilter.getSelectedCommand());
            request.setAttribute("users", this.userFilter.getSelectedCommand());
            request.setPage(this.pagePanel);
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//table");
                if (tableElement == null) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 Organizer");
                    return;
                }
                ArrayList dataRows = new ArrayList();
                for (Element rowElement : XMLUtils.selectElements((Node)tableElement, (String)"//table/data/row")) {
                    String period = rowElement.getAttribute("period");
                    String date1 = period.substring(0, period.indexOf("--"));
                    String date2 = period.substring(period.indexOf("--") + 3);
                    HashMap<String, Object> rowData = new HashMap<String, Object>();
                    rowData.put("id", Utils.parseInt((String)rowElement.getAttribute("id")));
                    rowData.put("status", rowElement.getAttribute("status"));
                    rowData.put("period", new Period(TimeUtils.convertStringToDate((String)date1), TimeUtils.convertStringToDate((String)date2)));
                    rowData.put("title", rowElement.getAttribute("title"));
                    rowData.put("who_complets", rowElement.getAttribute("who_complets"));
                    rowData.put("contract", rowElement.getAttribute("contract"));
                    rowData.put("user_name", rowElement.getAttribute("user_name"));
                    rowData.put("created", TimeUtils.parseDate((String)rowElement.getAttribute("created"), (String)"dd.MM.yyyy"));
                    rowData.put("comment", rowElement.getAttribute("comment"));
                    rowData.put("cid", Utils.parseInt((String)rowElement.getAttribute("cid")));
                    rowData.put("uid", Utils.parseInt((String)rowElement.getAttribute("uid")));
                    rowData.put("todo_uid", Utils.parseInt((String)rowElement.getAttribute("todo_uid")));
                    rowData.put("todo_gid", Utils.parseInt((String)rowElement.getAttribute("todo_gid")));
                    dataRows.add(rowData);
                }
                this.tableModel.setData(dataRows);
                this.pagePanel.setPageInfo(tableElement);
                this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + new DecimalFormat("###,###,###,##0").format(Utils.parseInt((String)tableElement.getAttribute("recordCount"))));
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.openEditor(true));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            if (this.tableModel.getSelectedRow() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                return;
            }
            this.openEditor(false);
        });
    }

    class CurrentTasksTableModel
    extends BGTableModel<Map<String, Object>> {
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_CID = "cid";
        public static final String COLUMN_STATUS = "status";
        public static final String COLUMN_PERIOD = "period";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_WHO_COMPLETS = "who_complets";
        public static final String COLUMN_CONTRACT = "contract";
        public static final String COLUMN_USER_NAME = "user_name";
        public static final String COLUMN_CREATED = "created";
        public static final String COLUMN_UID = "uid";
        public static final String COLUMN_COMMENT = "comment";
        public static final String COLUMN_TODO_UID = "todo_uid";
        public static final String COLUMN_TODO_GID = "todo_gid";

        public CurrentTasksTableModel() {
            super("organizerCurrentTasks");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 100, 100, COLUMN_STATUS, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f", 180, 180, 180, COLUMN_PERIOD, true, (TableCellRenderer)new PeriodTableCellRenderer());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 150, 500, COLUMN_CONTRACT, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0435\u043c\u0430", -1, -1, -1, COLUMN_TITLE, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u0443 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043e", 150, 150, 150, COLUMN_WHO_COMPLETS, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", 150, 150, 150, COLUMN_USER_NAME, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430", 90, 90, 90, COLUMN_CREATED, true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
        }
    }
}

