/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.warehouse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.WarehousePanel;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;

public class WarehouseListPanel
extends JPanel {
    private final WarehousePanel parentPanel;
    protected final BGUList<Warehouse> warehouseList = new BGUList();

    public WarehouseListPanel(final WarehousePanel parentPanel) {
        this.parentPanel = parentPanel;
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0421\u043a\u043b\u0430\u0434\u044b");
        this.warehouseList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.warehouseList.setCellRenderer((ListCellRenderer)new WarehouseListRenderer(this));
        this.warehouseList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Warehouse selected = (Warehouse)WarehouseListPanel.this.warehouseList.getSelectedValue();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && selected != null) {
                    parentPanel.getWarehouseEditorPanel().openEditor(selected);
                }
            }
        });
        this.add((Component)BGSwingUtilites.wrapScrollPane(this.warehouseList, (int)500, (int)300), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void reloadList() {
        try {
            this.warehouseList.setData(this.parentPanel.getWarehouseService().getWarehouseList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    protected Warehouse getSelectedWarehouseOrShowError() {
        Warehouse selected = (Warehouse)this.parentPanel.getWarehouseListPanel().warehouseList.getSelectedValue();
        if (selected == null) {
            BGToolTip.showErrorMessage(this.parentPanel.getWarehouseListPanel().warehouseList, (String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0441\u043a\u043b\u0430\u0434!");
        }
        return selected;
    }

    private final class WarehouseListRenderer
    implements ListCellRenderer<Warehouse> {
        private WarehouseListRenderer(WarehouseListPanel warehouseListPanel) {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Warehouse> list, Warehouse value, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel p = new JPanel(new GridBagLayout());
            BGSwingUtilites.wrapEmptyBorder((JComponent)p);
            p.setBackground(isSelected ? list.getSelectionBackground() : Color.WHITE);
            JLabel titleLabel = new JLabel(value.getTitle());
            titleLabel.setFont(new Font("Helvetica", 1, 18));
            p.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 0, 3), 0, 0));
            Object commentText = value.getComment();
            if (((String)commentText).length() > 60) {
                commentText = ((String)commentText).substring(0, 57) + "...";
            }
            JLabel comment = new JLabel((String)commentText);
            comment.setFont(new Font("Helvetica", 2, 12));
            return p;
        }
    }
}

