/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelDateWithTime;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.common.service.SubscriptionService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;

public class ContractGroupOperationFactory
implements ContractGroupOperation.ContractGroupOperationFactory {
    public Collection<ContractGroupOperation.ContractGroupOperationItem> getContractGroupOperations(String moduleId, String moduleTitle) {
        ArrayList<ContractGroupOperation.ContractGroupOperationItem> result = new ArrayList<ContractGroupOperation.ContractGroupOperationItem>(3);
        result.add(new AddSubscriptionContractGroupOperationItem("subscription", moduleId, moduleTitle));
        result.add(new CloseSubscriptionContractGroupOperationItem("subscription", moduleId, moduleTitle));
        result.add(new ActiveSubscriptionContractGroupOperationItem("subscription", moduleId, moduleTitle));
        return result;
    }

    private class AddSubscriptionContractGroupOperationItem
    extends BaseSubscriptionContractGroupOperationItem {
        BGTextArea comment;
        JCheckBox avtoCommit;
        BGControlPanelDateWithTime controlPanelPeriodFrom;
        BGControlPanelDateWithTime controlPanelPeriodTo;

        private AddSubscriptionContractGroupOperationItem(String module, String moduleId, String moduleTitle) {
            super(module, moduleId, moduleTitle);
            this.comment = null;
            this.avtoCommit = null;
            this.controlPanelPeriodFrom = null;
            this.controlPanelPeriodTo = null;
        }

        protected boolean doItemOperation(String contractIds) {
            boolean result = true;
            if (contractIds != null) {
                try {
                    int[] activeContractIds;
                    Subscription subscription = Subscription.builder().setPeriod(new PeriodWithTime(this.controlPanelPeriodFrom.getDate(), this.controlPanelPeriodTo.getDate())).setAvtoCommit(this.avtoCommit.isSelected()).setComment(this.comment.getText()).build();
                    for (int contractId : activeContractIds = ((SubscriptionService)((ClientContext)this.getContext()).getPort(SubscriptionService.class)).groupOperationAddSubscription(Utils.toIntArray((String)contractIds), this.subscriptionList.getSelectedIds(), subscription)) {
                        EventBus.publish((Object)new UpdateContractTreeEvent(((ClientContext)this.getContext()).getModuleId(), contractId));
                    }
                }
                catch (Exception ex) {
                    result = false;
                }
            }
            return result;
        }

        protected String getOperationTitle() {
            return this.moduleTitle + ": \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a";
        }

        protected void jbInit() throws Exception {
            this.subscriptionList = new BGControlPanelListSelect();
            this.subscriptionList.setName("subscriptionList");
            this.subscriptionList.setBorder((Border)new BGTitleBorder(" \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 "));
            this.subscriptionList.setMinimumSize(new Dimension(180, 200));
            this.subscriptionList.setPreferredSize(new Dimension(180, 200));
            this.add(this.getLeftPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.subscriptionList, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add(this.getCommentPanel(), new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        }

        private JPanel getCommentPanel() {
            this.comment = new BGTextArea();
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane((Component)this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            panel.setBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "));
            panel.setMinimumSize(new Dimension(300, 200));
            panel.setPreferredSize(new Dimension(300, 200));
            return panel;
        }

        private JPanel getLeftPanel() {
            this.avtoCommit = new JCheckBox("\u0410\u0432\u0442\u043e\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435");
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add((Component)this.avtoCommit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
            panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getPeriodPanel() {
            this.controlPanelPeriodFrom = new BGControlPanelDateWithTime();
            this.controlPanelPeriodTo = new BGControlPanelDateWithTime();
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
            panel.add((Component)new JLabel("c"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.controlPanelPeriodFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.controlPanelPeriodTo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            return panel;
        }
    }

    private class CloseSubscriptionContractGroupOperationItem
    extends BaseSubscriptionContractGroupOperationItem {
        BGControlPanelDateWithTime controlPanelPeriodTo;

        private CloseSubscriptionContractGroupOperationItem(String module, String moduleId, String moduleTitle) {
            super(module, moduleId, moduleTitle);
            this.controlPanelPeriodTo = null;
        }

        protected boolean doItemOperation(String contractIds) {
            boolean result = true;
            Date dateTo = this.controlPanelPeriodTo.getDate();
            if (contractIds != null && dateTo != null && dateTo.after(new Date())) {
                try {
                    int[] activeContractIds;
                    for (int contractId : activeContractIds = ((SubscriptionService)((ClientContext)this.getContext()).getPort(SubscriptionService.class)).groupOperationCloseSubscription(Utils.toIntArray((String)contractIds), this.subscriptionList.getSelectedIds(), dateTo)) {
                        EventBus.publish((Object)new UpdateContractTreeEvent(((ClientContext)this.getContext()).getModuleId(), contractId));
                    }
                }
                catch (Exception ex) {
                    result = false;
                }
            }
            return result;
        }

        protected String getOperationTitle() {
            return this.moduleTitle + ": \u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a";
        }

        protected void jbInit() throws Exception {
            this.subscriptionList = new BGControlPanelListSelect();
            this.subscriptionList.setName("subscriptionList");
            this.subscriptionList.setBorder((Border)new BGTitleBorder(" \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 "));
            this.subscriptionList.setMinimumSize(new Dimension(180, 200));
            this.subscriptionList.setPreferredSize(new Dimension(180, 200));
            this.add(this.getLeftPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.subscriptionList, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        private JPanel getLeftPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getPeriodPanel() {
            this.controlPanelPeriodTo = new BGControlPanelDateWithTime();
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.controlPanelPeriodTo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
            return panel;
        }
    }

    private class ActiveSubscriptionContractGroupOperationItem
    extends BaseSubscriptionContractGroupOperationItem {
        private ActiveSubscriptionContractGroupOperationItem(String module, String moduleId, String moduleTitle) {
            super(module, moduleId, moduleTitle);
        }

        protected boolean doItemOperation(String contractIds) {
            boolean result = true;
            if (contractIds != null) {
                try {
                    int[] activeContractIds;
                    for (int contractId : activeContractIds = ((SubscriptionService)((ClientContext)this.getContext()).getPort(SubscriptionService.class)).groupOperationActivateSubscription(Utils.toIntArray((String)contractIds), this.subscriptionList.getSelectedIds())) {
                        EventBus.publish((Object)new UpdateContractTreeEvent(((ClientContext)this.getContext()).getModuleId(), contractId));
                    }
                }
                catch (Exception ex) {
                    result = false;
                }
            }
            return result;
        }

        protected String getOperationTitle() {
            return this.moduleTitle + ": \u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a";
        }

        protected void jbInit() throws Exception {
            this.subscriptionList = new BGControlPanelListSelect();
            this.subscriptionList.setName("subscriptionList");
            this.subscriptionList.setBorder((Border)new BGTitleBorder(" \u041f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 "));
            this.subscriptionList.setMinimumSize(new Dimension(180, 200));
            this.subscriptionList.setPreferredSize(new Dimension(180, 200));
            this.add((Component)this.subscriptionList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }
    }

    private abstract class BaseSubscriptionContractGroupOperationItem
    extends ContractGroupOperation.ContractGroupOperationItem {
        protected final String moduleTitle;
        BGControlPanelListSelect subscriptionList;

        private BaseSubscriptionContractGroupOperationItem(String module, String moduleId, String moduleTitle) {
            super(module, Integer.valueOf(moduleId).intValue(), (LayoutManager)new GridBagLayout());
            this.subscriptionList = null;
            this.moduleTitle = moduleTitle;
        }

        protected void setData() {
            if (this.subscriptionList != null) {
                this.tryCall(() -> this.subscriptionList.getList().setData(((SubscriptionService)((ClientContext)this.getContext()).getWebService(SubscriptionService.class)).subscriptionTypeList().stream().map(a -> new BGUListItem(a.getId(), a.getTitle())).toList()));
            }
        }
    }
}

