/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.attributes;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToggleButton;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.client.directory.attributes.AttributesCommonPanel;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.common.Utils;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.list.BGUList;

public class AttributesKitPanel
extends AttributesCommonPanel<StockItemAttributeKit> {
    protected AttributesKitPanel() {
        super("\u041d\u0430\u0431\u043e\u0440\u044b \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432");
    }

    @Override
    protected void jbInit0() throws Exception {
    }

    @Override
    protected void refreshImpl() {
        try {
            this.list.setData(this.getWarehouseService().getAttributeKitList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    @Override
    protected void toolbarNewItem() throws BGException {
        new AttributesKitEditorDialog(null).open();
    }

    @Override
    protected void toolbarEditItem(StockItemAttributeKit attributeKit) throws BGException {
        new AttributesKitEditorDialog(attributeKit).open();
    }

    @Override
    protected void toolbarDeleteItem(StockItemAttributeKit attributeKit) throws Exception {
        this.getWarehouseService().deleteAttributeKit(attributeKit.getId());
        this.performAction("refresh");
    }

    private class AttributesKitEditorDialog
    extends BGEditorDialog<StockItemAttributeKit> {
        private JPanel editorPanel;
        private final JTextField title;
        private final BGUList<StockItemAttribute> selectedAttributes;
        private final JPanel selectAttributesPanel;
        private final BGUCheckList<StockItemAttribute> availableAttributes;
        private final JToggleButton toggleButton;
        private final JButton addSelectedAttributes;

        public AttributesKitEditorDialog(StockItemAttributeKit data) {
            super("\u041d\u0430\u0431\u043e\u0440 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432", (Object)data);
            this.title = new JTextField(20);
            this.selectedAttributes = new BGUList();
            this.selectAttributesPanel = new JPanel(new GridBagLayout());
            this.availableAttributes = new BGUCheckList();
            this.toggleButton = new BGToggleButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u044b \u0432 \u043d\u0430\u0431\u043e\u0440");
            this.addSelectedAttributes = new JButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0430\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u044b");
        }

        public void doDialogPanel() {
            this.editorPanel = new JPanel(new GridBagLayout());
            this.editorPanel.setPreferredSize(new Dimension(400, 500));
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 0, 3), 0, 0);
            this.selectAttributesPanel.add((Component)this.availableAttributes, constraints);
            this.selectAttributesPanel.add((Component)this.addSelectedAttributes, constraints);
            this.selectAttributesPanel.setVisible(false);
            this.editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), constraints);
            this.editorPanel.add((Component)this.title, constraints);
            this.editorPanel.add((Component)new JLabel("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442\u044b"), constraints);
            constraints.weighty = 1.0;
            constraints.fill = 1;
            this.editorPanel.add((Component)new JScrollPane((Component)this.selectedAttributes), constraints);
            constraints.weighty = 0.0;
            constraints.fill = 2;
            this.editorPanel.add((Component)this.toggleButton, constraints);
            constraints.weighty = 1.0;
            constraints.fill = 1;
            this.editorPanel.add((Component)this.selectAttributesPanel, constraints);
            this.panel.add(this.editorPanel);
            this.init();
        }

        private void init() {
            this.toggleButton.addActionListener(e -> {
                if (this.selectedAttributes.getModel().elements().hasMoreElements()) {
                    this.availableAttributes.setSelected(Collections.list(this.selectedAttributes.getModel().elements()));
                }
                this.selectAttributesPanel.setVisible(this.toggleButton.isSelected());
            });
            this.addSelectedAttributes.addActionListener(e -> {
                HashSet selected = new HashSet(Collections.list(this.selectedAttributes.getModel().elements()));
                selected.addAll(this.availableAttributes.getSelected());
                this.selectedAttributes.getModel().clear();
                this.selectedAttributes.getModel().addAll(selected);
                this.availableAttributes.clearSelection();
                this.toggleButton.doClick();
            });
            if (this.data != null) {
                this.title.setText(((StockItemAttributeKit)this.data).getTitle());
                if (Utils.notEmptyCollection((Collection)((StockItemAttributeKit)this.data).getAttributes())) {
                    this.selectedAttributes.setData(((StockItemAttributeKit)this.data).getAttributes());
                }
            }
            try {
                this.availableAttributes.setData(AttributesKitPanel.this.getWarehouseService().getAttributeList());
            }
            catch (Exception e2) {
                ClientUtils.showErrorMessageDialog((Throwable)e2);
            }
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.title.getText())) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (this.data == null) {
                this.data = new StockItemAttributeKit();
            }
            ((StockItemAttributeKit)this.data).setTitle(this.title.getText());
            if (!this.selectedAttributes.getModel().isEmpty()) {
                ((StockItemAttributeKit)this.data).setAttributes(Collections.list(this.selectedAttributes.getModel().elements()));
            }
            AttributesKitPanel.this.getWarehouseService().updateAttributeKit((StockItemAttributeKit)this.data);
            AttributesKitPanel.this.performAction("refresh");
            return true;
        }
    }
}

