/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDateTime;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class MegafonContractOptionPanel
extends BGUPanel {
    private MegafonService megafonService;
    private MegafonContractService megafonContractService;
    private List<MegafonOption> options;
    private BGUTable table;
    private ContractOptionTableModel tableModel;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.tableModel = new ContractOptionTableModel();
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1 && MegafonContractOptionPanel.this.tableModel.getSelectedRow() != null) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem item = new JMenuItem("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043e\u0441\u0442\u0430\u0442\u043a\u0438");
                    item.addActionListener(ev -> MegafonContractOptionPanel.this.showAvailableVolumeDialog());
                    menu.add(item);
                }
            }
        });
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.options = this.getMegafonService().getOptionList();
            this.tableModel.setData(this.getMegafonContractService().getContractOptions(null, ((ClientContext)this.getContext()).getContractId()).getList());
        });
    }

    private void showAvailableVolumeDialog() {
    }

    private MegafonService getMegafonService() {
        if (this.megafonService == null) {
            this.megafonService = (MegafonService)((ClientContext)this.getContext()).getPort(MegafonService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonService;
    }

    private MegafonContractService getMegafonContractService() {
        if (this.megafonContractService == null) {
            this.megafonContractService = (MegafonContractService)((ClientContext)this.getContext()).getPort(MegafonContractService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonContractService;
    }

    private final class ContractOptionTableModel
    extends BGTableModel<MegafonContractOption> {
        public ContractOptionTableModel() {
            super("megafonContractOptionTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041e\u043f\u0446\u0438\u044f", -1, -1, -1, "optionId", false);
            this.addColumn("ID \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", -1, 100, -1, "contractProductId", false);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 100, -1, "status", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430", -1, 100, -1, "startTime", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", -1, 100, -1, "endTime", false);
        }

        public Object getValueAt(MegafonContractOption val, int column) throws Exception {
            return switch (column) {
                case 1 -> MegafonContractOptionPanel.this.options.stream().filter(o -> o.getId() == val.getOptionId()).findFirst().map(IdTitle::getTitle).orElse("<\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>");
                case 3 -> val.getStatus().getComment();
                case 4 -> {
                    if (val.getStartTime() != null) {
                        yield TimeUtils.format((LocalDateTime)val.getStartTime(), (String)"dd.MM.yyyy HH:mm:ss");
                    }
                    yield "";
                }
                case 5 -> {
                    if (val.getEndTime() != null) {
                        yield TimeUtils.format((LocalDateTime)val.getEndTime(), (String)"dd.MM.yyyy HH:mm:ss");
                    }
                    yield "";
                }
                default -> super.getValueAt((Object)val, column);
            };
        }
    }
}

