/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;

public class ProductSpecActivationModeDao {
    private final Connection con;
    private final String tableName;

    public ProductSpecActivationModeDao(Connection con, int moduleId) {
        this.con = con;
        this.tableName = "inv_product_spec_activation_mode" + (String)(moduleId > 0 ? "_" + moduleId : "");
    }

    public ProductSpecActivationMode get(int id) throws BGException {
        ProductSpecActivationMode activationMode = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    activationMode = this.getFromRS(rs);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return activationMode;
    }

    public void delete(int id) throws BGException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected ProductSpecActivationMode getFromRS(ResultSet rs) throws SQLException, BGException {
        return ProductSpecActivationMode.builder().setId(rs.getInt("id")).setModuleId(rs.getInt("moduleId")).setTitle(rs.getString("title")).setDateFrom((Date)rs.getDate("dateFrom")).setDateTo((Date)rs.getDate("dateTo")).setPeriodMode(rs.getInt("periodMode")).setPeriodAmount(rs.getInt("periodAmount")).setDeactivationMode(rs.getInt("deactivationMode")).setReactivationMode(rs.getInt("reactivationMode")).build();
    }

    public void update(ProductSpecActivationMode activationMode) throws BGException {
        Objects.requireNonNull(activationMode);
        boolean update = activationMode.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET moduleId=?, title=?, dateFrom=?, dateTo=?, periodMode=?, periodAmount=?, deactivationMode=?, reactivationMode=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, activationMode.getModuleId());
            ps.setString(index++, activationMode.getTitle());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)activationMode.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)activationMode.getDateTo()));
            ps.setInt(index++, activationMode.getPeriodMode());
            ps.setInt(index++, activationMode.getPeriodAmount());
            ps.setInt(index++, activationMode.getDeactivationMode());
            ps.setInt(index++, activationMode.getReactivationMode());
            if (update) {
                ps.setInt(index++, activationMode.getId());
            }
            ps.executeUpdate();
            if (!update) {
                activationMode.setId(ServerUtils.lastInsertId(ps));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<ProductSpecActivationMode> listByModuleId(int moduleId) throws BGException {
        ArrayList<ProductSpecActivationMode> result = new ArrayList<ProductSpecActivationMode>();
        String query = "SELECT mode.* FROM " + this.tableName + " AS mode WHERE moduleId=0 OR moduleId=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<ProductSpecActivationMode> list(int productSpecId) throws BGException {
        ArrayList<ProductSpecActivationMode> result = new ArrayList<ProductSpecActivationMode>();
        String query = "SELECT mode.* FROM " + this.tableName + " AS mode WHERE productSpecId=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, productSpecId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<ProductSpecActivationMode> list(List<Integer> ids) throws BGException {
        ArrayList<ProductSpecActivationMode> result = new ArrayList<ProductSpecActivationMode>();
        if (ids != null && !ids.isEmpty()) {
            String query = "SELECT mode.* FROM " + this.tableName + " AS mode WHERE id IN ( " + Utils.toString(ids) + " ) ORDER BY title";
            try (PreparedStatement ps = this.con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    public List<ProductSpecActivationMode> list() throws BGException {
        ArrayList<ProductSpecActivationMode> result = new ArrayList<ProductSpecActivationMode>();
        String query = "SELECT * FROM " + this.tableName + " AS mode ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

