/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.function;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.function.Async;
import ru.bitel.common.function.ThrowingSupplier;

public class Expirable<T>
implements Supplier<T>,
Serializable {
    private static final long serialVersionUID = 0L;
    final Supplier<T> delegate;
    final long durationNanos;
    volatile transient T value;
    volatile transient long expirationNanos;

    Expirable(Supplier<T> delegate, long duration, TimeUnit unit) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate");
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration");
        }
        this.delegate = delegate;
        this.durationNanos = unit.toNanos(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        long nanos = this.expirationNanos;
        long now = System.nanoTime();
        if (nanos == 0L || now - nanos >= 0L) {
            Expirable expirable = this;
            synchronized (expirable) {
                if (nanos == this.expirationNanos) {
                    T t = this.delegate.get();
                    this.value = t;
                    nanos = now + this.durationNanos;
                    this.expirationNanos = nanos == 0L ? 1L : nanos;
                    return t;
                }
            }
        }
        return this.value;
    }

    public String toString() {
        return "Expirable(" + String.valueOf(this.delegate) + ", " + this.durationNanos + ", NANOS)";
    }

    public static <T> Expirable<T> of(ThrowingSupplier<T> delegate, long duration, TimeUnit unit) {
        return new Expirable<T>(delegate, duration, unit);
    }

    public static <T> Expirable<T> of(final Supplier<T> first, final ThrowingSupplier<T> delegate, long duration, TimeUnit unit) {
        ThrowingSupplier s = new ThrowingSupplier<T>(){
            private Supplier<T> first0;
            {
                this.first0 = first;
            }

            @Override
            public T getThrows() throws BGException {
                if (this.first0 != null) {
                    try {
                        Object t = this.first0.get();
                        return t;
                    }
                    finally {
                        this.first0 = null;
                    }
                }
                return delegate.get();
            }
        };
        return new Expirable<T>(s, duration, unit);
    }

    public static <T> Expirable<T> asyncOf(final ThrowingSupplier<T> delegate, long duration, TimeUnit unit) {
        ThrowingSupplier s = new ThrowingSupplier<T>(){
            private Async<T> async;
            {
                this.async = Async.of(delegate);
            }

            @Override
            public T getThrows() throws BGException {
                if (this.async != null) {
                    try {
                        Object t = this.async.get();
                        return t;
                    }
                    finally {
                        this.async = null;
                    }
                }
                return delegate.get();
            }
        };
        return new Expirable<T>(s, duration, unit);
    }
}

