/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.bean;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ru.bitel.bgbilling.kernel.map.bean.MapMarker;

public class MapTrack
implements Iterable<MapMarker> {
    private final List<MapMarker> points = new LinkedList<MapMarker>();

    public MapTrack() {
    }

    public MapTrack(List<MapMarker> points) {
        points.forEach(this::addPoint);
    }

    public void removeLastPoint() {
        if (this.points.size() > 0) {
            this.points.remove(this.points.size() - 1);
        }
    }

    public void addPoint(MapMarker point) {
        this.addPoint(this.points.size(), point);
    }

    public void addPoint(int position, MapMarker point) {
        int size = this.points.size();
        if (position == 0) {
            if (size > 0) {
                // empty if block
            }
            point.setVisible(true);
        } else if (position >= size) {
            if (size > 1) {
                // empty if block
            }
            point.setVisible(true);
        }
        this.points.add(position, point);
    }

    public List<MapMarker> getPoints() {
        return this.points;
    }

    public MapMarker getFirstPoint() {
        if (this.points.size() == 0) {
            return null;
        }
        return this.points.get(0);
    }

    public MapMarker getLastPoint() {
        if (this.points.size() == 0) {
            return null;
        }
        return this.points.get(this.points.size() - 1);
    }

    @Override
    public Iterator<MapMarker> iterator() {
        return this.points.iterator();
    }
}

