/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;

public abstract class AbstractEditor
extends BGUPanel {
    protected JTextField title = new JTextField();
    protected JTextArea description = new JTextArea();
    protected BGButtonPanelOkCancel buttonPanel = new BGButtonPanelOkCancel();
    protected JButton selectPicture = new BGButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
    protected JLabel productPicture = new JLabel();
    private File pictureFile;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440");
        this.buttonPanel.getButtonOk().addActionListener(e -> {
            try {
                this.actionSave();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
        });
        this.buttonPanel.getButton("cancel").addActionListener(e -> this.setVisible(false));
        this.initSelectPictureButton();
        BGSwingUtilites.wrapBorder((JComponent)this.productPicture, (String)"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435");
    }

    private void initSelectPictureButton() {
        BGFileChooser fileChooser = new BGFileChooser((Component)((Object)this));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new FileFilter(this){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String fileName = file.getName().toLowerCase();
                return fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".png");
            }

            @Override
            public String getDescription() {
                return "(*.jpg, *.jpeg, *.png)";
            }
        });
        this.selectPicture.addActionListener(e -> {
            if (fileChooser.showOpenDialog() == 0) {
                this.pictureFile = fileChooser.getSelectedFile();
                if (this.pictureFile != null) {
                    byte[] bytesPicture = new byte[(int)this.pictureFile.length()];
                    try {
                        FileInputStream fis = new FileInputStream(this.pictureFile);
                        fis.read(bytesPicture);
                        fis.close();
                        this.setPicture(bytesPicture);
                    }
                    catch (IOException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
    }

    protected void setPicture(byte[] picture) {
        if (picture == null) {
            this.productPicture.setIcon(null);
            return;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(picture));
            if (bufferedImage != null) {
                Image image = bufferedImage.getScaledInstance(150, 100, 4);
                this.productPicture.setIcon(new ImageIcon(image));
            } else {
                this.productPicture.setIcon(null);
            }
        }
        catch (IOException ex) {
            ClientUtils.showErrorMessageDialog((String)ex.getMessage());
        }
    }

    protected byte[] getSelectedPicture() {
        byte[] bytesPicture = null;
        if (this.pictureFile != null && this.pictureFile.exists()) {
            bytesPicture = new byte[(int)this.pictureFile.length()];
            try {
                FileInputStream fis = new FileInputStream(this.pictureFile);
                fis.read(bytesPicture);
                fis.close();
            }
            catch (IOException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return bytesPicture;
    }

    public void performActionOpen() {
        this.setVisible(true);
        this.setPicture(null);
        this.actionOpen();
    }

    protected abstract void actionOpen();

    protected abstract void actionSave() throws Exception;

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.showErrorDialog());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showErrorDialog());
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> this.showErrorDialog());
    }

    private void showErrorDialog() {
        ClientUtils.showErrorMessageDialog((String)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043d\u043e\u043f\u043a\u0438 \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u0438\u043b\u0438 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0439!");
    }

    protected abstract void newItem();

    protected abstract void editItem();

    protected abstract void deleteItem();

    protected JScrollPane getDescriptionPanel() {
        JScrollPane scrollPane = new JScrollPane(this.description);
        Dimension dimension = new Dimension(600, 200);
        scrollPane.setMinimumSize(dimension);
        scrollPane.setPreferredSize(dimension);
        this.description.setLineWrap(true);
        return scrollPane;
    }
}

