/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.service;

import bitel.billing.server.contract.bean.ContractModuleManager;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.common.service.TinkoffService;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffAutopaymentEvent;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffCheckEvent;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.tinkoff.common.service.TinkoffService")
public class TinkoffServiceImpl
extends AbstractService
implements TinkoffService {
    @Resource
    private ContractAutopaymentService contractAutopaymentService;

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(searchParam.getPeriod(), searchParam.getPage(), searchParam.getSort());
            new TransactionManager(this.getConnection(), this.moduleId).searchTransaction(searchResult, searchParam);
            return searchResult;
        });
    }

    public void checkTransactions(int contractId) throws BGException {
        this.tryCall(() -> {
            EventProcessor.getInstance().publish((Event)new TinkoffCheckEvent(this.moduleId, contractId, true));
            EventProcessor.getInstance().publish((Event)new TinkoffCheckEvent(this.moduleId, contractId, false));
        });
    }

    public Autopayment autopaymentGet(int contractId) throws BGException {
        return (Autopayment)this.tryReturn(() -> new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId));
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException {
        this.tryCall(() -> this.beginAutopaymentTransaction(contractId, amount, url, mode, paramsHolder, null));
    }

    public void beginAutopaymentTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder, ContractAutopaymentMode autopaymentMode) throws BGException {
        this.tryCall(() -> {
            if (contractId <= 0 && this.moduleId <= 0) {
                throw new BGIllegalArgumentException();
            }
            BigDecimal sum = Optional.ofNullable(amount).map(a -> a.setScale(2, RoundingMode.HALF_EVEN)).orElse(null);
            if (sum == null || sum.compareTo(BigDecimal.ZERO) <= 0) {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.incorrect");
            }
            if (!new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(this.moduleId)) {
                throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.", "contractModule.notEnabled");
            }
            if (mode != null) {
                mode.value = "redirect";
            }
            ModuleSetup moduleSetup = this.getModuleSetup();
            if (autopaymentMode == null) {
                BigDecimal sumMin = moduleSetup.getBigDecimal("tinkoff.sum.min", new BigDecimal(100));
                BigDecimal sumMax = moduleSetup.getBigDecimal("tinkoff.sum.max", new BigDecimal(5000));
                if (sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
                    throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!", "amount.invalid");
                }
            }
            Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
            String resultUrl = (String)params.get("resultUrl");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), Integer.valueOf(contractId));
            String contractTitle = contractRuntime.getContractTitle();
            String customerAddress = (String)params.get("receiptTo");
            String paymentPhone = (String)params.get("paymentPhone");
            if (autopaymentMode != null) {
                this.autopayment(contractId, contractTitle, autopaymentMode, customerAddress, dataMap, resultUrl);
            } else {
                TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
                transactionManager.registerOrder(contractId, contractTitle, customerAddress, sum, dataMap, false, false, resultUrl, BGTransactionType.CARD, paymentPhone);
            }
            url.value = Optional.ofNullable(dataMap.get("PaymentURL")).map(a -> String.valueOf(a)).orElse(null);
            if (url.value == null) {
                String message = String.valueOf(dataMap.containsKey("Details") ? dataMap.get("Details") : dataMap.get("Message"));
                throw new BGMessageException(message + " [ErrorCode=" + String.valueOf(dataMap.get("ErrorCode")) + "]");
            }
            if (paramsHolder != null) {
                paramsHolder.value = new MapHolder(dataMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> String.valueOf(e.getValue()))));
            }
        });
    }

    public void autopaymentDeactivate(int contractId) throws BGException {
        this.tryCall(() -> {
            ContractAutopaymentMode.ContractAutopaymentModePeriodic mode = new ContractAutopaymentMode.ContractAutopaymentModePeriodic();
            mode.setMode(AutopaymentMode.OFF);
            this.autopayment(contractId, null, (ContractAutopaymentMode)mode, null, null, null);
        });
    }

    private void autopayment(int contractId, String contractTitle, ContractAutopaymentMode mode, String customerAddress, Map<String, Object> dataMap, String resultUrl) throws Exception {
        AutopaymentManager autopaymentManager;
        Autopayment autopayment;
        if (mode != null && mode.getMode() != AutopaymentMode.OFF) {
            this.contractAutopaymentService.contractAutopaymentModeCheck(contractId, mode);
        }
        if ((autopayment = (autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId)).getCurrentAutopayment(contractId)) != null) {
            if (autopayment.getMode() != AutopaymentMode.OFF) {
                autopaymentManager.autopaymentOff(autopayment);
            }
            if (mode.getMode() != autopayment.getMode()) {
                autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                autopaymentManager.updateAutopayment(autopayment);
                autopayment = null;
            }
        } else if (mode.getMode() == AutopaymentMode.OFF) {
            throw new BGMessageException("\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d.", "autopayment.notFound");
        }
        if (autopayment == null) {
            autopayment = new Autopayment().setContractId(contractId);
        }
        if (mode.getMode() == AutopaymentMode.OFF) {
            autopayment.setMode(AutopaymentMode.OFF).setModeData("").setSum(BigDecimal.ZERO).setPeriod(new PeriodWithTime(LocalDateTime.now(), null)).setAccessToken(null);
        } else {
            mode.toAutopayment(autopayment);
            String paymentPhone = ContractUtils.getPaymentPhone((Connection)this.getConnection(), (int)this.moduleId, (int)contractId);
            TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
            transactionManager.registerOrder(contractId, contractTitle, customerAddress, autopayment.getSum(), dataMap, false, true, resultUrl, BGTransactionType.CARD, paymentPhone);
        }
        autopaymentManager.updateAutopayment(autopayment);
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
        this.tryCall(() -> new TransactionManager(this.getConnection(), this.moduleId).doCheckRequest(contractId, false));
    }

    public List<String[]> getAutopaymentBindingData(int contractId) throws BGException {
        return (List)this.tryReturn(() -> {
            ModuleSetup moduleSetup = this.getModuleSetup();
            String billingName = moduleSetup.get("tinkoff.billing.name", Setup.getSetup().get("billing.name"));
            StringBuilder clientId = new StringBuilder();
            if (billingName != null) {
                clientId.append(billingName).append("_");
            }
            clientId.append(this.moduleId).append("_").append(contractId);
            StringBuilder spec = new StringBuilder();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
            }
            String resultJson = "{}";
            try (HttpClient httpClient = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(spec.toString())).GET().build();
                resultJson = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: " + resultJson);
                }
            }
            ArrayList<String[]> list = new ArrayList<String[]>();
            String[] errorData = new String[2];
            JSONObject resultJsonObject = new JSONObject(resultJson);
            if (resultJsonObject.has("errorCode")) {
                errorData[0] = resultJsonObject.getString("errorCode");
            }
            if (resultJsonObject.has("errorMessage")) {
                errorData[1] = resultJsonObject.getString("errorMessage");
            }
            if (resultJsonObject.has("bindings")) {
                JSONArray array = resultJsonObject.getJSONArray("bindings");
                for (int index = 0; index < array.length(); ++index) {
                    JSONObject jsonObject = array.getJSONObject(index);
                    String[] listData = new String[]{jsonObject.getString("bindingId"), jsonObject.getString("maskedPan"), jsonObject.getString("expiryDate")};
                    list.add(listData);
                }
            }
            list.add(0, errorData);
            return list;
        });
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult(period, page, sort);
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
            autopaymentManager.searchAutopayment(searchResult, contractId);
            return searchResult;
        });
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
        if (contractId > 0) {
            this.tryCall(() -> {
                Autopayment autopayment = new AutopaymentManager(this.getConnection(), this.moduleId).getCurrentAutopayment(contractId);
                if (autopayment != null && autopayment.getMode().getCode() == AutopaymentMode.AUTO.getCode() && sum != null) {
                    EventProcessor.getInstance().publish((Event)new TinkoffAutopaymentEvent(this.moduleId, contractId, AutopaymentMode.AUTO.getCode(), sum));
                }
            });
        }
    }

    public void cancelTarnsaction(int transactionId) throws BGException {
        this.tryCall(() -> new TransactionManager(this.getConnection(), this.moduleId).doCancelTransaction(transactionId));
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return null;
    }
}

