/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.service;

import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionCheckResultDTO;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.assist.common.service.AssistService;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.assist.common.service.AssistService")
public class AssistServiceImpl
extends AbstractService
implements AssistService {
    private TransactionManager getTransactionManager() {
        return new TransactionManager(this.getConnection(), this.moduleId);
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> paramsHolder) throws BGException {
        BigDecimal sum;
        if (contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (mode != null) {
            mode.value = "post";
        }
        if ((sum = amount).compareTo(BigDecimal.ZERO) <= 0) {
            throw new BGIllegalArgumentException("amount.invalid");
        }
        this.tryCall(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            this.getTransactionManager().registerOrder(contractId, sum, dataMap, false, false);
            map.put("RecurringIndicator", "0");
            BigDecimal RecurringMinAmount = this.getModuleSetup().getBigDecimal("assist.RecurringMinAmount", null);
            BigDecimal RecurringMaxAmount = this.getModuleSetup().getBigDecimal("assist.RecurringMaxAmount", null);
            int RecurringPeriod = this.getModuleSetup().getInt("assist.RecurringPeriod", -1);
            boolean RecurringAllowed = RecurringMinAmount != null && RecurringMaxAmount != null && RecurringPeriod != -1;
            AssistPaymentRecurringManager assistPaymentRecurringManager = new AssistPaymentRecurringManager(this.getConnection(), this.moduleId);
            AssistPaymentRecurring recurringAlreadyHas = assistPaymentRecurringManager.getRecurring(contractId);
            if (recurringAlreadyHas != null) {
                RecurringAllowed = false;
            }
            if (RecurringAllowed) {
                Map params = Optional.ofNullable(paramsHolder).map(a -> (MapHolder)a.value).map(MapHolder::getMap).orElse(Collections.emptyMap());
                boolean recurringCheckbox = Utils.parseInt((String)((String)params.get("recurring")), (int)0) > 0;
                String RecurringMaxDate = Utils.maskNull((String)((String)params.get("recurringMaxDate")));
                Date dRecurringMaxDate = TimeUtils.parseDate((String)RecurringMaxDate, (String)"yyyy-MM-dd");
                if (dRecurringMaxDate == null) {
                    dRecurringMaxDate = new Date(0L);
                }
                if (recurringCheckbox) {
                    map.put("RecurringIndicator", "1");
                    map.put("RecurringMinAmount", RecurringMinAmount.toPlainString());
                    map.put("RecurringMaxAmount", RecurringMaxAmount.toPlainString());
                    map.put("RecurringPeriod", String.valueOf(RecurringPeriod));
                    map.put("RecurringMaxDate", RecurringMaxDate);
                    AssistPaymentRecurring assistPaymentRecurring = new AssistPaymentRecurring();
                    assistPaymentRecurring.setContractId(contractId);
                    assistPaymentRecurring.setDate(new Date());
                    assistPaymentRecurring.setAmount(sum);
                    assistPaymentRecurring.setRecurringMinAmount(RecurringMinAmount);
                    assistPaymentRecurring.setRecurringMaxAmount(RecurringMaxAmount);
                    assistPaymentRecurring.setRecurringPeriod(RecurringPeriod);
                    assistPaymentRecurring.setRecurringMaxDate(dRecurringMaxDate);
                    assistPaymentRecurringManager.add(assistPaymentRecurring);
                }
            }
            url.value = this.getModuleSetup().get("assist.gate.url", "https://payments.paysecure.ru/pay/order.cfm");
            if (paramsHolder != null) {
                dataMap.entrySet().forEach(a -> map.put((String)a.getKey(), String.valueOf(a.getValue())));
                paramsHolder.value = new MapHolder(map);
            }
        });
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
    }

    public List<AssistPaymentRecurring> getRecurringList() throws Exception {
        return new AssistPaymentRecurringManager(this.getConnection(), this.moduleId).getRecurringList(-1);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws Exception {
        SearchResult searchResult = new SearchResult(searchParam);
        this.getTransactionManager().searchTransaction((SearchResult<Transaction>)searchResult, searchParam.getContractId(), searchParam.getContractTitle(), searchParam.getStatus());
        return searchResult;
    }

    public Transaction transactionGet(int id) throws Exception {
        return (Transaction)this.getTransactionManager().get(id);
    }

    public int transactionUpdate(int id, BigDecimal sum, TransactionStatus status, String comment) throws Exception {
        TransactionManager transactionManager = this.getTransactionManager();
        Transaction transaction = (Transaction)transactionManager.get(id);
        if (transaction != null) {
            boolean needPayment;
            boolean bl = needPayment = !transaction.getStatus().equals(TransactionStatus.OK.getCode()) && status == TransactionStatus.OK;
            if (comment != null) {
                transaction.setComment(comment);
            }
            if (status != null) {
                transaction.setStatus(status.getCode());
            }
            if (sum != null) {
                transaction.setSum(sum);
            }
            transactionManager.update(transaction);
            if (needPayment) {
                transactionManager.carryOutPayment(transaction);
            }
            return transaction.getId();
        }
        throw new BGMessageException("\u041f\u043b\u0430\u0442\u0451\u0436 \u0441 \u0442\u0430\u043a\u0438\u043c ID \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
    }

    public void recurringDelete(int contractId) throws Exception {
        AssistPaymentRecurringManager assistPaymentRecurringManager = new AssistPaymentRecurringManager(this.getConnection(), this.moduleId);
        AssistPaymentRecurring assistPaymentRecurring = assistPaymentRecurringManager.getRecurring(contractId);
        if (assistPaymentRecurring == null) {
            throw new BGMessageException("\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        assistPaymentRecurringManager.deleteRecurring(contractId);
    }

    public void recurringDo(int contractId, BigDecimal sum) throws Exception {
        AssistPaymentRecurringManager assistPaymentRecurringManager = new AssistPaymentRecurringManager(this.getConnection(), this.moduleId);
        AssistPaymentRecurring assistPaymentRecurring = assistPaymentRecurringManager.getRecurring(contractId);
        if (assistPaymentRecurring == null) {
            throw new BGMessageException("\u0420\u0435\u043a\u0443\u0440\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0451\u0436 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        assistPaymentRecurringManager.runRecurring(contractId, sum);
    }

    public List<TransactionCheckResultDTO> transactionCheck(int contractId) throws Exception {
        return this.getTransactionManager().doCheckRequest(contractId, true);
    }

    public List<AssistPaymentRecurring> recurringList(int contractId) throws Exception {
        return new AssistPaymentRecurringManager(this.getConnection(), this.moduleId).getRecurringList(contractId);
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        return null;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return null;
    }
}

