/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.action;

import java.util.Date;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;
import ru.bitel.bgbilling.modules.hd.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.hd.server.bean.ZoneDAO;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class ActionGetContractZoneData
extends ActionBase {
    public void doAction() throws Exception {
        int zoneId = this.getIntParameter("zone_id", -1);
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element zoneElement = this.createElement(this.rootNode, "zone");
        if (zoneId > 0) {
            Zone zone = null;
            for (Zone z : new ZoneDAO(this.con, this.mid).getZoneList(this.cid)) {
                if (z.getId() != zoneId) continue;
                zone = z;
            }
            if (zone != null) {
                zoneElement.setAttribute("id", String.valueOf(zone.getId()));
                zoneElement.setAttribute("name", zone.getZone());
                zoneElement.setAttribute("punycode", zone.getZonePunycode());
                zoneElement.setAttribute("date_from", TimeUtils.formatDate((Date)zone.getPeriod().getDateFrom()));
                zoneElement.setAttribute("date_to", TimeUtils.formatDate((Date)zone.getPeriod().getDateTo()));
                zoneElement.setAttribute("comment", zone.getComment());
                zoneElement.setAttribute("whois", String.valueOf(zone.isLoadWhois()));
                zoneElement.setAttribute("avto", String.valueOf(zone.isAvto()));
                zoneElement.setAttribute("whois_last_update", TimeUtils.format((Date)zone.getWhoisLastUpdate(), (String)"dd.MM.yyyy HH:mm:ss"));
                XMLUtils.createTextNode((Node)this.createElement(zoneElement, "config"), (String)zone.getConfig());
                zoneElement.setAttribute("records", zone.getData());
            } else {
                throw new BGMessageException("Zone not found");
            }
        }
        Element defaultsElement = this.createElement(zoneElement, "defaults");
        ParameterMap pm = this.moduleSetup.sub("zone.default.");
        for (Map.Entry s : pm.entrySet()) {
            defaultsElement.setAttribute((String)s.getKey(), (String)s.getValue());
        }
    }
}

