/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.tree.BGCheckTreeModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.TreeNode;

class CheckTreeCellRenderer<N extends Id>
extends JPanel
implements TreeCellRenderer {
    private final BGCheckTreeModel<N> model;
    private final DefaultTreeCellRenderer renderer;
    private final JCheckBox checkBox;
    private boolean mark;
    private static final Color colorMarkWinRollover = new Color(33, 161, 33);
    private static final Color colorMarkWin = new Color(116, 194, 116);
    private static final Color colorMarkPgs = new Color(60, 127, 177);
    private Color markColor;

    public CheckTreeCellRenderer(BGCheckTreeModel<N> model) {
        super(new FlowLayout(0, 0, 0));
        this.model = model;
        this.renderer = new DefaultTreeCellRenderer();
        this.renderer.setOpenIcon(ClientUtils.getIcon("node"));
        this.renderer.setClosedIcon(ClientUtils.getIcon("node"));
        this.renderer.setLeafIcon(ClientUtils.getIcon("leaf"));
        this.checkBox = new JCheckBox();
        Color bColor = UIManager.getColor("Tree.textBackground");
        this.setBackground(bColor);
        this.checkBox.setBackground(bColor);
        this.setOpaque(false);
        this.add(this.checkBox);
        this.add(this.renderer);
        this.checkBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 5));
    }

    private Color getMarkColor() {
        if (this.markColor == null) {
            this.markColor = this.getMarkColor0();
        }
        return this.markColor;
    }

    private Color getMarkColor0() {
        ButtonModel buttonmodel = this.checkBox.getModel();
        String name = UIManager.getLookAndFeel().getClass().getName();
        if (!name.endsWith("MotifLookAndFeel")) {
            if (!buttonmodel.isEnabled()) {
                return UIManager.getColor("CheckBox.shadow");
            }
            if (!name.endsWith("WindowsLookAndFeel")) {
                if (name.endsWith("PgsLookAndFeel")) {
                    return colorMarkPgs;
                }
                return UIManager.getColor("CheckBox.darkShadow");
            }
            if (buttonmodel.isRollover() || !this.checkBox.isRolloverEnabled()) {
                return colorMarkWinRollover;
            }
            return colorMarkWin;
        }
        return UIManager.getColor("CheckBox.foreground");
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.mark) {
            g.setColor(this.getMarkColor());
            g.fillRect(this.checkBox.getX() + 5, this.checkBox.getY() + 5, 3, 3);
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof TreeNode) {
            Id v = (Id)value;
            Icon icon = this.model.getIcon(v);
            if (icon != null) {
                this.renderer.setIcon(icon);
            }
            boolean checked = this.model.isChecked(v);
            this.mark = false;
            if (checked) {
                this.checkBox.setSelected(true);
            } else {
                this.checkBox.setSelected(false);
                this.mark = this.needMark(v);
            }
        } else {
            this.checkBox.setSelected(false);
        }
        if (value instanceof GuiTitlable) {
            this.renderer.setText(((GuiTitlable)value).getGuiTitle());
        }
        this.invalidate();
        this.validate();
        return this;
    }

    private boolean needMark(N node) {
        if (((TreeNode)node).getChildren() != null) {
            for (Id n : ((TreeNode)node).getChildren()) {
                if (this.model.isChecked(n)) {
                    return true;
                }
                if (!this.needMark(n)) continue;
                return true;
            }
        }
        return false;
    }
}

