<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>


<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'TrayInfo'">Активизация логинов TrayInfo</xsl:when>
</xsl:choose>
</xsl:template>


<xsl:template match="/data">
<xsl:if test="@action = 'TrayInfo'">
	<xsl:call-template name="TrayInfo"/>
</xsl:if>
</xsl:template>


<xsl:template name="TrayInfo">
	<form method='post' action='{$WEBEXECUTER}'>
		<xsl:call-template name="action"/>		
		<xsl:if test="count(logins/data/item) > 0">
			<div class="report">
				<table cellspacing='1' class="table800">
				<thead>
					<tr>
						<td nowrap='1'>PIN1</td>
						<td nowrap='1'>PIN2 ( выделите мышкой )</td>
						<td>С даты</td>
						<td>По дату</td>
  					</tr>
				</thead>
				<tbody>
  					<xsl:for-each select="logins/data/item">
					<tr>
						<xsl:if test="@activeNow = 'false'">
							<xsl:attribute name="style">color: #8e8e8e;</xsl:attribute>
						</xsl:if>
						<td><xsl:value-of select="@login"/></td>
						<td class="password"><xsl:value-of select="@password"/></td>
						<td><xsl:value-of select="@date1"/></td>
						<td><xsl:value-of select="@date2"/></td>
					</tr>
  					</xsl:for-each>
				</tbody>
				</table>
			</div>
		</xsl:if>

		<xsl:if test="hasActive!='true'">
		<br/>
			<table cellspacing='0' class="filter">
				<tr>
					<td>Тип:</td>
					<td>
						<select name="type">
							<xsl:for-each select="types/data/item">
								<option><xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
									<xsl:value-of select="@title"/> 
									( на 
									<xsl:if test="@days='0'">бесконечный срок</xsl:if>
									<xsl:if test="@days!='0'"> <xsl:value-of select="@days"/> дней </xsl:if>									
									 за <xsl:value-of select="@cost"/> руб. )
								</option>
							</xsl:for-each>
						</select>				
					</td>
					<td>PIN2:</td>
					<td><input type="password" name="pswd" size="20" /></td>
					<td>
						<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Активировать'"/>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</xsl:if>
	</form>
</xsl:template>

</xsl:stylesheet>