/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseCoordinates;

public class HouseCoordinatesDao {
    private static final String TABLE_NAME = "house_coordinates";
    private final Connection connection;

    public HouseCoordinatesDao(Connection connection) {
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HouseCoordinates getCoordinatesByHouseId(int houseId) throws BGException {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM house_coordinates WHERE house_id=?");){
            ps.setInt(1, houseId);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                HouseCoordinates houseCoordinates = new HouseCoordinates(rs.getInt("house_id"), rs.getDouble("latitude"), rs.getDouble("longitude"));
                return houseCoordinates;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void save(HouseCoordinates coordinates) throws BGException {
        boolean isUpdate = this.isUpdate(coordinates.getHouseId());
        String prefix = isUpdate ? "UPDATE " : "INSERT INTO ";
        String query = prefix + "house_coordinates SET latitude=?, longitude=?" + (isUpdate ? " WHERE house_id=?" : ", house_id=?");
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setDouble(1, coordinates.getLatitude());
            ps.setDouble(2, coordinates.getLongitude());
            ps.setInt(3, coordinates.getHouseId());
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isUpdate(int houseId) throws BGException {
        try (PreparedStatement ps = this.connection.prepareStatement("SELECT * FROM house_coordinates WHERE house_id=?");){
            boolean bl;
            block14: {
                ps.setInt(1, houseId);
                ResultSet rs = ps.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void delete(int houseId) throws BGException {
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM house_coordinates WHERE house_id=?");){
            ps.setInt(1, houseId);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

