function showAction( id, masterId, actionId, formData )
{
	fetch( context + "/assistant/action/" + masterId + "/" + actionId, { method: 'POST', body: formData } )
		.then( response => response.text() )
		.then( result => {
			let divEl = jQuery("div#"+id);
			if ( typeof divEl !== 'undefined' )
			{
				divEl.html( result );
			}
		} );
	return false;
}

function doButton( buttonCode, masterId, actionId, formData )
{
	let query = Object.assign( {} );
	let a = { method: "POST", dataType: "json", data: query };
	if ( formData !== undefined ) 
	{
		let f = new FormData(formData);
		let formFiled = {};
		for ( let [name, value] of f)
		{
			// alert( name );
			if ( name.startsWith( "Boolean_" ) )
			{
				if ( name.endsWith( "_Value" ) )
				{
					formFiled[name.substring( 8, name.length-6)] = f.has(name.substring(0,name.length-6));
				}
			}
			else if ( name.startsWith( "Integer_" ) )
			{
				formFiled[name.substring( 8 )] = parseInt(value, 10);
			}
			else if ( name.startsWith( "Date_" ) )
			{
				formFiled[name.substring( 5 )] = value;
			}
			else if ( name.startsWith( "Period_" ) && name.endsWith( "_From" ) )
			{
				name = name.substring( 7, name.length-5 );
				formFiled[name] = { ...formFiled[name], from: value };
			}
			else if ( name.startsWith( "Period_" ) && name.endsWith( "_To" ) )
			{
				name = name.substring( 7, name.length-3 );
				formFiled[name] = { ...formFiled[name], to: value };
			}
			else
			{
				formFiled[name.substring(name.indexOf( "_" ) + 1)] = value;
			}
		}		
		query['data'] = JSON.stringify(formFiled);
		//operation.set( 'module', inQuery.module );
		//operation.set( 'mid', inQuery.mid );
		//operation.set( 'contractId', inQuery.contractId );
		//query = operation;
		//processData = false;
		//contentType = false;
	};	
	jQuery.ajax( context + "/assistant/doButton/" + masterId + "/" + actionId + "/" + buttonCode, a )
		.done( function( data ) 
		{
 			if ( data.fields !== undefined && data.fields.openContract !== undefined )
			{
				showBlock( "contracts", context + "/assistant/contract/" + data.fields.openContract );
			}			
			if ( data.status == 'error' )
			{
				alert( data.error );
			}
			else if ( data.nextActionId !== undefined )
			{
				hideMenu();
				let f = new FormData();
				f.append( 'data', a.data['data'] );
				if ( data.fields )
				{
					f.append( 'fields', JSON.stringify( data.fields ) );
				}
				showAction( "action", masterId, data.nextActionId, f );
			}
			else
			{
				showMenu();
			}
		} );	
	return false;
}

function showBlock( id, url, inParam )
{
	let processData = true;
	let contentType = 'application/x-www-form-urlencoded; charset=UTF-8';
	let query = Object.assign({}, inParam);
//	if ( typeof operation == 'string' ) {
//		query.operation = operation; 
//	} 
//	else if ( operation instanceof FormData ) {
//		operation.set( 'action', inQuery.action );
//		operation.set( 'module', inQuery.module );
//		operation.set( 'mid', inQuery.mid );
//		operation.set( 'contractId', inQuery.contractId );
//		query = operation;
//		processData = false;
//		contentType = false;
//	}
//	else { jQuery.extend( query, operation ) };
    jQuery.ajax(
	{
		url: url,
		type: 'POST',
		dataType: 'html',    
		data: query,
		processData: processData,
	    contentType: contentType,		
		success: function( data )
		{
			let divEl = jQuery("div#"+id);
			if ( typeof divEl !== 'undefined' )
			{
				divEl.html( data );
			}
		}
	});
	return false;
}

function showMenu( contractId )
{
	hideSearch()
	hideAction();
	showBlock( "menu", context + "/assistant/menu" + ( contractId ? "?contractId=" + contractId : "" ) );
	return false;
}

function hideMenu()
{
	jQuery("div#menu").html( "" );
}

function hideAction()
{
	jQuery("div#action").html( "" );
}

function hideSearch()
{
	jQuery("div#search").html( "" );
}

function search( searchForm )
{
	hideMenu();
	hideAction();
	return showBlock( "search", context + "/assistant/search?txt=" + encodeURI(searchForm.txt.value) );
}