/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.manager;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractNotification;
import ru.bitel.common.Utils;

public class FireMessage
extends BGLogger {
    private Map<String, Object> root;
    private String serverKey;
    private String url;

    public FireMessage(String serverKey, String url, String title, MobileContractNotification notification, int type) throws JSONException {
        this.serverKey = serverKey;
        this.url = url;
        this.root = new HashMap<String, Object>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("title", title);
        data.put("notificationN", (String)notification);
        this.root.put("data", data);
        if (type == 3) {
            this.root.put("content_available", true);
            boolean donShow = false;
            boolean withoutSound = false;
            if (notification.getParams() != null) {
                donShow = Utils.parseBoolean((String)((String)notification.getParams().get("doNotShow")), (boolean)false);
                withoutSound = Utils.parseBoolean((String)((String)notification.getParams().get("withoutSound")), (boolean)false);
            }
            if (!donShow) {
                HashMap<String, String> notificationd = new HashMap<String, String>();
                notificationd.put("title", title);
                notificationd.put("body", notification.getText());
                if (!withoutSound) {
                    notificationd.put("sound", "default");
                }
                this.root.put("notification", notificationd);
            }
        }
    }

    public String sendToTopic(String topic) {
        System.out.println("Send to Topic");
        this.root.put("condition", "'" + topic + "' in topics");
        return this.sendPushNotification(true);
    }

    public String sendToGroup(JSONArray mobileTokens) {
        this.root.put("registration_ids", mobileTokens);
        return this.sendPushNotification(false);
    }

    public String sendToToken(String token) {
        this.root.put("to", token);
        return this.sendPushNotification(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String sendPushNotification(boolean toTopic) {
        try (HttpClient httpClient = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.url)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "key=" + this.serverKey).POST(HttpRequest.BodyPublishers.ofString(new ObjectMapper().writeValueAsString(this.root))).build();
            String result = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            JSONObject obj = new JSONObject(result);
            if (toTopic) {
                if (obj.has("message_id")) {
                    String string = "SUCCESS";
                    return string;
                }
            } else {
                int success = obj.optInt("success", -1);
                if (success > 0) {
                    String string = "SUCCESS";
                    return string;
                }
            }
            String string = result;
            return string;
        }
        catch (Exception ex) {
            this.logError(ex);
            return ex.getMessage();
        }
    }
}

