/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.installer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.server.installer.ExecuteSQL;
import ru.bitel.bgbilling.server.installer.InstallationCall;
import ru.bitel.bgbilling.server.installer.ModuleInf;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class InstallerModule {
    protected static final String MESSAGE_ERROR = "ERROR";
    protected static final String MESSAGE_OK = "OK";
    public static final String LIB_APP_DIR = "lib/app";
    private String init;
    private String uninstall;

    public InstallerModule(File zip, List<String> replacedFiles) {
        this(zip, replacedFiles, false);
    }

    public InstallerModule(File zip, List<String> replacedFiles, boolean onlyCopyFiles) {
        ModuleInf mi = InstallerModule.getModuleInf(zip);
        if (mi != null && !mi.hasErrors()) {
            boolean result = true;
            if (result) {
                result = this.takeClientZipAndInit(zip, mi.getName());
                System.out.println("Extract data => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result && !onlyCopyFiles) {
                result = this.updateBase(mi);
                System.out.println("Base update => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result && !onlyCopyFiles) {
                result = this.initModules(mi);
                System.out.println("Module Instance init => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result && !onlyCopyFiles) {
                this.executeCalls(mi, Setup.getSetup(), zip, replacedFiles);
                System.out.println("Execute calls => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result) {
                result = this.copyFiles(zip, replacedFiles, mi);
                System.out.println("File copy => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result) {
                result = InstallerModule.removeLibs(mi);
                System.out.println("Remove libs => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (!result) {
                System.out.println("Module was not installed.");
            } else {
                System.out.println("Module " + mi.getName() + " was successfull installed!");
                System.out.println("Please, restart BGBilling server.");
            }
        }
    }

    private static boolean removeLibs(ModuleInf mi) {
        if (!Utils.isEmptyString((String)mi.getLibsRemove())) {
            String[] removeList;
            for (String lib : removeList = mi.getLibsRemove().split(",")) {
                File file = new File("lib/ext/" + lib);
                if (!file.exists()) continue;
                System.out.println("Removing library  " + file.getAbsolutePath());
                file.delete();
            }
        }
        return true;
    }

    private static ModuleInf getModuleInf(File zip) {
        ModuleInf mi = null;
        try {
            FileInputStream fis = new FileInputStream(zip);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals("module.xml")) continue;
                mi = new ModuleInf(XMLUtils.parseDocument((byte[])Utils.readByBlock((InputStream)zis)));
                break;
            }
            if (mi == null) {
                System.err.println("Error: module.xml not found in zip " + zip.getAbsolutePath());
            }
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mi;
    }

    private boolean takeClientZipAndInit(File zip, String name) {
        boolean result = false;
        try {
            FileInputStream fis = new FileInputStream(zip);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getName().equals("client.zip")) {
                    File clientJarDir = new File("client.jars");
                    if (!clientJarDir.exists()) {
                        clientJarDir.mkdir();
                    }
                    File nameJarDir = new File(clientJarDir, name);
                    ServerUtils.deleteDir(nameJarDir);
                    nameJarDir.mkdir();
                    ZipInputStream clientZipInputStream = new ZipInputStream(new ByteArrayInputStream(Utils.readByBlock((InputStream)zis)));
                    ZipEntry clientZipEntry = null;
                    while ((clientZipEntry = clientZipInputStream.getNextEntry()) != null) {
                        if (!clientZipEntry.getName().endsWith(".jar")) continue;
                        File clientJar = new File(nameJarDir, clientZipEntry.getName());
                        try (FileOutputStream fos = new FileOutputStream(clientJar);){
                            fos.write(Utils.readByBlock((InputStream)clientZipInputStream));
                        }
                    }
                    clientZipInputStream.close();
                    continue;
                }
                if (ze.getName().equals("init")) {
                    this.init = new String(Utils.readByBlock((InputStream)zis), "UTF-8");
                    continue;
                }
                if (!ze.getName().equals("uninstall")) continue;
                this.uninstall = new String(Utils.readByBlock((InputStream)zis), "UTF-8");
            }
            fis.close();
            System.out.println("Data extract finished...");
            result = true;
        }
        catch (Exception ex) {
            System.err.println("Data extract error...");
            ex.printStackTrace();
        }
        return result;
    }

    private boolean copyFiles(File zip, List<String> replacedFiles, ModuleInf mi) {
        boolean result = false;
        String serverZip = "server.zip";
        File libDir = new File(LIB_APP_DIR);
        File xslDir = new File("webroot/xsl");
        String libExtPath = new File("lib/ext").getAbsolutePath();
        if (libDir.exists() && libDir.isDirectory() && xslDir.exists() && xslDir.isDirectory()) {
            try {
                String libPath = libDir.getAbsolutePath();
                FileInputStream fis = new FileInputStream(zip);
                ZipInputStream zis = new ZipInputStream(fis);
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    if (!ze.getName().equals(serverZip)) continue;
                    byte[] serv_zip = Utils.readByBlock((InputStream)zis);
                    ZipInputStream jarsZip = new ZipInputStream(new ByteArrayInputStream(serv_zip));
                    ZipEntry jarE = null;
                    while ((jarE = jarsZip.getNextEntry()) != null) {
                        FileOutputStream fos = null;
                        fos = "ext".equals(mi.getLibType()) ? new FileOutputStream(libExtPath + File.separator + jarE.getName()) : new FileOutputStream(libPath + File.separator + jarE.getName());
                        byte[] jarFile = Utils.readByBlock((InputStream)jarsZip);
                        fos.write(jarFile);
                        fos.close();
                    }
                }
                fis.close();
                System.out.println("File's copy finished...");
                result = true;
            }
            catch (Exception ex) {
                System.err.println("File's copy error.. ");
                ex.printStackTrace();
            }
        } else {
            System.err.println("Can't find xsl or lib path!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initModules(ModuleInf mi) {
        boolean result = false;
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            if (mi.getType().equals("module")) {
                System.out.println("Reinit module instanses");
                for (BGModule module : (ArrayList)new ModuleManager(con).getModules(mi.getName())) {
                    System.out.println("REINIT module => " + module.getId());
                    InstallerModule.initModule(con, mi.getName(), module.getId());
                }
            } else if (mi.getType().equals("plugin")) {
                System.out.println("Reinit plugin id=" + mi.getPluginId());
                InstallerModule.initModule(con, mi.getName(), mi.getPluginId());
            }
            result = true;
        }
        catch (Exception e) {
            System.err.println("Error of module reinit...");
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBase(ModuleInf mi) {
        boolean result = false;
        Connection con = Setup.getSetup().getDBConnection();
        try (PreparedStatement psSelect = con.prepareStatement("SELECT id FROM installed_modules WHERE name=?");){
            String query = null;
            int recordId = 0;
            psSelect.setString(1, mi.getName());
            ResultSet rs = psSelect.executeQuery();
            if (rs.next()) {
                recordId = rs.getInt(1);
            }
            rs.close();
            if (recordId > 0) {
                query = "UPDATE installed_modules SET version=?, title=?, client_zip=?, init=?, uninstall=?, pack_server=?, pack_client=? WHERE name=?";
                PreparedStatement psUpdate = con.prepareStatement(query);
                psUpdate.setString(1, "");
                psUpdate.setString(2, mi.getTitle());
                psUpdate.setBytes(3, new byte[0]);
                psUpdate.setString(4, this.init);
                psUpdate.setString(5, this.uninstall);
                psUpdate.setString(6, mi.getPackageServer());
                psUpdate.setString(7, mi.getPackageClient());
                psUpdate.setString(8, mi.getName());
                psUpdate.executeUpdate();
                psUpdate.close();
            } else {
                query = "INSERT INTO installed_modules SET name=?, title=?, version=?, pack_server=?, pack_client=?, type=?, client_zip=?, init=?, uninstall=?";
                PreparedStatement psInsert = con.prepareStatement(query, 1);
                psInsert.setString(1, mi.getName());
                psInsert.setString(2, mi.getTitle());
                psInsert.setString(3, "");
                psInsert.setString(4, mi.getPackageServer());
                psInsert.setString(5, mi.getPackageClient());
                psInsert.setString(6, mi.getType());
                psInsert.setBytes(7, new byte[0]);
                psInsert.setString(8, this.init);
                psInsert.setString(9, this.uninstall);
                psInsert.executeUpdate();
                recordId = ServerUtils.lastInsertId(psInsert);
                psInsert.close();
            }
            mi.setPluginId(recordId);
            System.out.println("Database updated...");
            ServerUtils.removeSetupValue(con, "20");
            ServerUtils.setSetupValue(con, "20", "1");
            System.out.println("Install ticket inserted..");
            result = true;
        }
        catch (Exception ex) {
            System.err.println("Error of updating database.");
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }

    private void executeCalls(ModuleInf moduleInf, Setup setup, File zip, List<String> replacedFiles) {
        List<String[]> calls = moduleInf.getCalls();
        for (String[] class_param : calls) {
            String callClass = class_param[0];
            String param = class_param[1];
            System.out.println("Executing call " + callClass + "; param: " + param);
            boolean result = false;
            try {
                StringBuffer fullClassName = new StringBuffer("ru.bitel.bgbilling.server.installer.");
                fullClassName.append(callClass);
                InstallationCall call = (InstallationCall)Class.forName(fullClassName.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (call instanceof ExecuteSQL) {
                    int id = 0;
                    if ("plugin".equals(moduleInf.getType()) || "module".equals(moduleInf.getType())) {
                        id = moduleInf.getPluginId();
                    }
                    ((ExecuteSQL)call).setId(String.valueOf(id));
                }
                call.call(setup, zip, param);
                result = true;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
            System.out.println("Result => " + result);
        }
    }

    public static void uninstallModuleInstance(Connection con, String name, int mid) {
        try {
            String query = "SELECT uninstall FROM installed_modules WHERE name=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            String uninstall = null;
            if (rs.next() && (uninstall = rs.getString(1)) != null) {
                String[] queries = uninstall.split(";\r*\n*");
                int size = queries.length;
                Statement st = con.createStatement();
                for (int i = 0; i < size; ++i) {
                    queries[i] = queries[i].trim();
                    if (queries[i].length() <= 0) continue;
                    query = queries[i].replaceAll("\\$mid", String.valueOf(mid));
                    try {
                        st.executeUpdate(query);
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                    }
                }
                st.close();
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void initModule(Connection con, String name, int moduleId) {
        String query = "SELECT init, type FROM installed_modules WHERE name=?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    boolean isModule = "module".equals(rs.getString(2));
                    String[] lines = rs.getString(1).split(";\r*\n*");
                    for (int i = 0; i < lines.length; ++i) {
                        lines[i] = lines[i].trim();
                        if (lines[i].length() <= 0) continue;
                        lines[i] = lines[i].replaceAll("\\$mid", String.valueOf(moduleId));
                    }
                    String midStr = (isModule ? "m" : "") + moduleId;
                    InstallerModule.executeSqlComands(con, lines, midStr);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlComands(Connection con, String[] lines, String midStr) throws SQLException {
        Statement st;
        List<String> hashes = InstallerModule.getQueryHashes(con, midStr);
        ArrayList<String> blockQueries = new ArrayList<String>();
        boolean blockStarted = false;
        boolean noHash = false;
        try {
            st = con.createStatement();
            try {
                st.executeUpdate("SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0");
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i].trim();
                    if (line.isEmpty()) continue;
                    if (line.indexOf("#BLOCK#") >= 0) {
                        blockStarted = true;
                    } else if (line.indexOf("#ENDB#") >= 0) {
                        blockStarted = false;
                        InstallerModule.tryExecuteBlock(con, blockQueries, hashes, st);
                        blockQueries.clear();
                    } else if (line.indexOf("#NOHASH#") >= 0) {
                        noHash = true;
                    } else if (line.indexOf("#ENDNO#") >= 0) {
                        noHash = false;
                    }
                    if (blockStarted) {
                        blockQueries.add(line);
                        continue;
                    }
                    if (noHash) {
                        try {
                            st.executeUpdate(line);
                        }
                        catch (SQLException ex) {
                            InstallerModule.printSQLException(ex, line);
                        }
                        continue;
                    }
                    if (line.indexOf("$yyyymm") > -1) {
                        String tableName = line.replaceFirst("^.* `?(.*\\$yyyymm).*$", "$1");
                        ArrayList<String> tableNames = new ArrayList<String>();
                        try (ResultSet rs = st.executeQuery("SHOW TABLES");){
                            while (rs.next()) {
                                String name = rs.getString(1).trim();
                                if (name.length() != tableName.length() - 1 || !name.startsWith(tableName.substring(0, name.length() - 7))) continue;
                                tableNames.add(name);
                            }
                        }
                        for (String name : tableNames) {
                            String newLine = line.replace(name.substring(0, name.length() - 6) + "$yyyymm", name);
                            InstallerModule.hashQueryExecuteUpdate(newLine, hashes, con);
                        }
                        continue;
                    }
                    InstallerModule.hashQueryExecuteUpdate(line, hashes, con);
                }
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        finally {
            st = con.createStatement();
            try {
                st.executeUpdate("SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS");
            }
            finally {
                if (st != null) {
                    st.close();
                }
            }
        }
        InstallerModule.updateHashes(con, Utils.toString(hashes), midStr);
    }

    private static void hashQueryExecuteUpdate(String line, List<String> hashes, Connection con) {
        String hash = InstallerModule.getHash(line);
        if (hashes.indexOf(hash) < 0) {
            try (Statement st = con.createStatement();){
                st.executeUpdate(line);
                hashes.add(hash);
            }
            catch (SQLException ex) {
                hashes.add(hash);
                InstallerModule.printSQLException(ex, line);
            }
        }
    }

    private static void printSQLException(SQLException ex, String line) {
        String prepline = Stream.of(line.split("\n")).map(String::trim).filter(line1 -> !line1.isBlank()).filter(line1 -> !line1.startsWith("--")).collect(Collectors.joining(" "));
        if (ex.getErrorCode() == 1060 || ex.getErrorCode() == 1054 || ex.getErrorCode() == 1061 || ex.getErrorCode() == 1091) {
            return;
        }
        System.err.println("(" + ex.getErrorCode() + ") " + ex.getMessage() + " -> " + prepline);
    }

    public static void tryExecuteBlock(Connection con, List<String> linesBlock, List<String> hashes, Statement st) {
        String hash = InstallerModule.getHash(Utils.toString(linesBlock));
        if (hashes.indexOf(hash) < 0) {
            for (String line : linesBlock) {
                try {
                    st.executeUpdate(line);
                    hashes.add(hash);
                }
                catch (SQLException ex) {
                    InstallerModule.printSQLException(ex, line);
                }
            }
        }
    }

    public static String getHash(String value) {
        return Utils.getDigest((String)value, (String)"UTF-8", (String)"MD5");
    }

    public static List<String> getQueryHashes(Connection con, String moduleId) throws SQLException {
        List<String> result = new ArrayList<String>();
        if (!ServerUtils.tableExists(con, "sql_patches_history")) {
            InstallerModule.createSQLPatchesHistoryTable(con);
            return result;
        }
        String query = "SELECT versions FROM sql_patches_history WHERE mid=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setString(1, moduleId);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = Utils.toList((String)rs.getString(1));
        }
        rs.close();
        ps.close();
        return result;
    }

    private static void createSQLPatchesHistoryTable(Connection con) throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS `sql_patches_history` (  `mid` varchar(10) NOT NULL,  `versions` text,  PRIMARY KEY  (`mid`) )";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.executeUpdate();
        }
    }

    public static void updateHashes(Connection con, String versions, String mid) throws SQLException {
        String query = "UPDATE sql_patches_history SET versions=? WHERE mid=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setString(1, versions);
        ps.setString(2, mid);
        if (ps.executeUpdate() == 0) {
            ps.close();
            query = "INSERT INTO sql_patches_history SET versions=?, mid=?";
            ps = con.prepareStatement(query);
            ps.setString(1, versions);
            ps.setString(2, mid);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void replacedReport(List<String> replacedFiles) {
        if (replacedFiles.size() > 0) {
            System.out.println("REPLACED FILES:");
            for (String file : replacedFiles) {
                System.out.println(file);
            }
        }
    }

    public static void clearHashById(String hashid) {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();
             PreparedStatement ps = con.prepareStatement("DELETE FROM sql_patches_history WHERE mid=?");){
            if (!ServerUtils.tableExists(con, "sql_patches_history")) {
                InstallerModule.createSQLPatchesHistoryTable(con);
                return;
            }
            ps.setString(1, hashid);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

