/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.server.service;

import jakarta.activation.DataSource;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineSubscription;
import ru.bitel.bgbilling.modules.softline.common.bean.SoftLineTypeProduct;
import ru.bitel.bgbilling.modules.softline.common.bean.SotfLineProductCategory;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineProductService;
import ru.bitel.bgbilling.modules.softline.common.service.SoftLineSubscriptionService;
import ru.bitel.bgbilling.modules.softline.server.bean.ProductCategoryDao;
import ru.bitel.bgbilling.modules.softline.server.bean.SoftlineProductDao;
import ru.bitel.bgbilling.modules.softline.server.filestorage.SoftlineCategoryFileStorage;
import ru.bitel.bgbilling.modules.softline.server.filestorage.SoftlineProductFileStorage;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.softline.common.service.SoftLineProductService")
public class SoftLineProductServiceImpl
extends AbstractService
implements SoftLineProductService {
    private SoftlineProductDao productDao;
    private ProductCategoryDao productCategoryDao;

    @PostConstruct
    public void init() {
        this.productDao = new SoftlineProductDao(this.getConnection(), this.moduleId);
        this.productCategoryDao = new ProductCategoryDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<SoftLineProduct> getProducts(Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(new ArrayList());
        this.productDao.getProducts((SearchResult<SoftLineProduct>)searchResult);
        return searchResult;
    }

    public void updateProduct(SoftLineProduct product) throws Exception {
        this.productDao.update(product);
    }

    public void deleteProduct(SoftLineProduct product) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        SoftLineSubscriptionService subscriptionService = (SoftLineSubscriptionService)serverContext.getService(SoftLineSubscriptionService.class, this.moduleId);
        List subscriptions = subscriptionService.searchSubscriptions(null, null, -1, -1, null, product.getId()).getList();
        if (subscriptions != null && subscriptions.size() > 0) {
            for (SoftLineSubscription subscription : subscriptions) {
                subscriptionService.deleteSubscription(subscription, true);
            }
        }
        this.productDao.delete(product.getId());
    }

    public List<SoftLineProduct> getProductsOfCategory(int productCategoryId) throws Exception {
        return this.productDao.getProductsOfCategory(productCategoryId);
    }

    public SoftLineProduct getProduct(int productId) throws Exception {
        return (SoftLineProduct)this.productDao.get(productId);
    }

    public SearchResult<SotfLineProductCategory> getProductCategories(Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(new ArrayList());
        this.productCategoryDao.getList((SearchResult<SotfLineProductCategory>)searchResult);
        return searchResult;
    }

    public SotfLineProductCategory getCategoryOfProduct(int productCategoryId) throws Exception {
        return (SotfLineProductCategory)this.productCategoryDao.get(productCategoryId);
    }

    public void updateProductCategory(SotfLineProductCategory productCategory) throws Exception {
        this.productCategoryDao.update(productCategory);
    }

    public void deleteProductCategory(SotfLineProductCategory productCategory) throws Exception {
        for (SoftLineProduct product : this.getProductsOfCategory(productCategory.getId())) {
            product.setProductCategoryId(0);
            this.productDao.update(product);
        }
        this.productCategoryDao.delete(productCategory.getId());
    }

    public void setProductPicture(int id, byte[] picture, SoftLineTypeProduct type) throws Exception {
        if (picture != null) {
            String prefix = type == SoftLineTypeProduct.PRODUCT ? "product_picture_" : "product_category_picture_";
            ByteArrayInputStream is = new ByteArrayInputStream(picture);
            BGServerFile bgFile = new BGServerFile();
            bgFile.setTitle(prefix + id + ".png");
            bgFile.setSize((long)((InputStream)is).available());
            bgFile.setOwnerId(id);
            bgFile.setComment("");
            bgFile.setDate(new Date());
            FileStorage fileStorage = this.getFileStorage(type);
            fileStorage.updateFile(bgFile);
            if (bgFile.getId() > 0) {
                String extension = FilenameUtils.getExtension((String)bgFile.getTitle());
                fileStorage.saveStream(bgFile.getId(), (InputStream)is, Utils.isBlankString((String)extension) ? "" : extension);
            }
        }
    }

    public byte[] getProductPicture(int productId, SoftLineTypeProduct type) throws Exception {
        String path;
        File file;
        FileStorage fileStorage = this.getFileStorage(type);
        List files = fileStorage.getFilesListByOwner(productId);
        if (files != null && files.size() > 0 && (file = new File(path = fileStorage.getFileName(((BGServerFile)files.get(0)).getId()))).exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                byte[] bytesPicture = new byte[(int)file.length()];
                fis.read(bytesPicture);
                byte[] byArray = bytesPicture;
                return byArray;
            }
        }
        return new byte[0];
    }

    public FileDto getProductPicture0(int productId, SoftLineTypeProduct type) throws Exception {
        FileStorage fileStorage = this.getFileStorage(type);
        List files = fileStorage.getFilesListByOwner(productId);
        if (files != null && files.size() > 0) {
            return FileDto.fromDataSource((DataSource)fileStorage.getDataSource(((BGServerFile)files.get(0)).getId()));
        }
        return null;
    }

    private FileStorage getFileStorage(SoftLineTypeProduct type) throws Exception {
        return type == SoftLineTypeProduct.PRODUCT ? new SoftlineProductFileStorage(this.getConnection(), this.moduleId) : new SoftlineCategoryFileStorage(this.getConnection(), this.moduleId);
    }
}

