<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<script>
function selectContact( id, contractId, contractTitle )
{
	document.getElementById( id + 'ContractListPopup' ).style.display = 'none';
	document.getElementById( id + 'Button' ).innerHTML = contractTitle;
	document.getElementById( id ).value = contractId;
}
</script>

<style>
	div.contractItem { padding-left: 0.5rem; padding-right: 0.5rem; }
	div.contractItem:hover { background-color: #ddd; }
</style>

<div class="pageTitle">${assistantAction.title}</div>
<c:if test="${not empty message}"><div class="alert alert-primary">${message}</div></c:if>

<form>
<c:if test="${not empty fields}">
<div class="tile actionFields">
	<c:forEach var="item" items="${fields}">
		<div class="actionField actionType${item.type}" style="position: relative;"> 
			<c:choose>
				<c:when test="${item.type == 'Hidden'}"><input type="hidden" name="${item.type}_${item.key}" value="${item.value}" id="${item.key}"></c:when>
				<c:when test="${item.type == 'Label'}"><div class="actionFieldRow"><label class="actionFieldTitle" for="${item.key}">${item.title}</label><div id="${item.key}" class="actionFieldValue">${item.value}</div></div>
				</c:when>
				<c:otherwise>
					<div class="actionFieldRow">
					<label class="actionFieldTitle" for="${item.key}">${item.title}</label>
					<div class="actionFieldValue">
					<c:choose>
						<c:when test="${item.type == 'String'}"><input class="form-control" type="text" name="${item.type}_${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Boolean'}"><input class="form-check-input" type="checkbox" name="${item.type}_${item.key}" value="${item.value}" id="${item.key}"><input type="hidden" name="${item.type}_${item.key}_Value" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Integer'}"><input type="number" pattern="^\d+$" name="${item.type}_${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Decimal'}"><input type="number" pattern="\d+.?\d*" name="${item.type}_${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Date'}"><input type="date" name="${item.type}_${item.key}" value="${item.value}" id="${item.key}"></c:when>
						<c:when test="${item.type == 'Period'}"><input type="date" name="${item.type}_${item.key}_From" value="${item.valueFrom}" id="${item.key}_From"> - <input type="date" name="${item.type}_${item.key}_To" value="${item.valueTo}" id="${item.key}_To"></c:when>
						<c:when test="${item.type == 'Contract'}">
							<input type="hidden" name="${item.type}_${item.key}" value="${item.value}" id="${item.key}">
							<div style="position: relative;">
								<div class="d-flex">
									<button type="button" name="${item.type}_${item.key}" id="${item.key}Button" class="actionFieldContractButton" onclick="document.getElementById('${item.key}ContractListPopup').style.display='block'; return false;"><c:choose><c:when test="${not empty item.value}">${item.value}</c:when><c:otherwise>Выберите договор...</c:otherwise></c:choose></button> 
									<button type="button" name="${item.type}_${item.key}Clear" id="${item.key}Clear" class="actionFieldContractButtonClear" onclick="selectContact( '${item.key}', '${item.value}', 'Выберите договор...' );">X</button>
								</div>
								<div id="${item.key}ContractListPopup" style="display: none; position: absolute; top: 1.6rem; padding: 5px; border: 1px solid; border-radius: 5px; z-index: 100; background-color: white; width: 100%;">
									<c:forEach var="contractItem" items="${contractIds}"><div class="contractItem" onclick="selectContact( '${item.key}', '${contractItem.id}', '${contractItem.title}' );">${contractItem.title}</div></c:forEach>
								</div>
							</div>
						</c:when>
						<c:when test="${item.type == 'Combox'}"><select name="${item.type}_${item.key}" id="${item.key}"><c:forEach var="listItem" items="${item.values}"><c:set var="selected"><c:if test="${listItem.key eq item.selectedKey}">selected="selected"</c:if></c:set><option value="${listItem.key}" ${selected}>${listItem.value}</option></c:forEach></select></c:when>
						<c:when test="${item.type == 'Textarea'}"><textarea class="form-control" rows="5" cols="30" name="${item.type}_${item.key}" id="${item.key}">${item.value}</textarea> </c:when>
						<c:when test="${item.type == 'Link'}"><a href="${item.value}" id="${item.key}">${item.value}</a></c:when>
						<c:when test="${item.type == 'List'}"><select name="${item.type}_${item.key}" id="${item.key}" size="6"><c:forEach var="listItem" items="${item.values}"><c:set var="selected"><c:if test="${listItem.key eq item.selectedKey}">selected="selected"</c:if></c:set><option value="${listItem.key}" ${selected}>${listItem.value}</option></c:forEach></select></c:when>
					</c:choose>
					<c:if test="${not empty item.comment}"><div class="actionFieldComment">${item.comment}</div></c:if>
					</div>
					</div>
				</c:otherwise>
			</c:choose>
		</div>			
	</c:forEach>			
</div>
</c:if>
<div class="actionButtons mt-3">
	<c:forEach var="item" items="${buttons}">
	<c:set var="onclick">
	<c:choose>
		<c:when test="${item.code == 'cancel'}">showMenu(); return false;</c:when>
		<c:otherwise>doButton( '${item['code']}', ${masterId}, '${assistantAction.actionId}', this.form ); return false;</c:otherwise>
	</c:choose>
	</c:set>
	<div><button class="btn btn-primary" value="${item['code']}" onclick="${onclick}">${item['title']}</button></div>
	</c:forEach>
</div>
</form>
