/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.util.List;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;

public class ChildAccountCountTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TvTariffContext, TreeContext, TvTariffWorkerContext> {
    private final int count;
    private final int mode;

    public ChildAccountCountTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.count = parameterMap.getInt("count", 0);
        String compare = parameterMap.get("compare");
        this.mode = "<".equals(compare) ? -2 : ("<=".equals(compare) ? -1 : ("=".equals(compare) ? 0 : (">=".equals(compare) ? 1 : (">".equals(compare) ? 2 : -100))));
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TvTariffContext ctx, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        TvAccountRuntimeMap tvAccountRuntimeMap = ctx.getTvAccountRuntimeMap();
        try {
            tvAccountRuntimeMap.load(workerContext.getConnectionSet(), req.contractId);
            List<TvAccountRuntime> children = req.getTvAccountId() == 0 ? tvAccountRuntimeMap.list(req.contractId, req.getTime().getTimeInMillis()) : tvAccountRuntimeMap.listChildren(req.getTvAccountId(), req.getTime().getTimeInMillis());
            int count = children != null ? children.size() : 0;
            switch (this.mode) {
                case -2: {
                    if (count < this.count) {
                        return 1;
                    }
                    break;
                }
                case -1: {
                    if (count <= this.count) {
                        return 1;
                    }
                    break;
                }
                case 1: {
                    if (count >= this.count) {
                        return 1;
                    }
                    break;
                }
                case 2: {
                    if (count > this.count) {
                        return 1;
                    }
                    break;
                }
                default: {
                    if (count == this.count) {
                        return 1;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return 0;
    }
}

