/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.protocols;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.common.ParameterMap;

public class ProtocolManager
extends BGLogger {
    private Map<Integer, ProtocolCurrency> protocols = null;

    public ProtocolManager(ParameterMap moduleSetup) {
        HashMap<Integer, ProtocolCurrency> protocols = new HashMap<Integer, ProtocolCurrency>();
        SortedMap indexedConfig = moduleSetup.subIndexed("currency.");
        for (Map.Entry pair : indexedConfig.entrySet()) {
            Integer id = (Integer)pair.getKey();
            ParameterMap config = (ParameterMap)pair.getValue();
            try {
                Class<?> clazz = Class.forName(config.get("protocol", null));
                ProtocolCurrency protocolCurrency = (ProtocolCurrency)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                protocolCurrency.setConfig(config);
                protocolCurrency.setLogger(this.getLogger());
                protocols.put(id, protocolCurrency);
            }
            catch (Exception e) {
                this.getLogger().error("error create class for ProtocolCurrency id=" + id, (Throwable)e);
            }
        }
        this.protocols = Collections.unmodifiableMap(protocols);
    }

    public Map<Integer, ProtocolCurrency> getProtocols() {
        return this.protocols;
    }
}

