/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import java.util.Base64;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicSourceData;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;

public class ClientDynLoader
extends ClassLoader {
    private DynamicCodeService dynamicCodeService;
    private String packName;

    public ClientDynLoader(ClientContext clientContext, String packName) {
        super(Thread.currentThread().getContextClassLoader());
        this.dynamicCodeService = (DynamicCodeService)clientContext.getPort(DynamicCodeService.class);
        this.packName = packName;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            DynamicSourceData dynamicSourceData = this.dynamicCodeService.getSourceData(name);
            byte[] classData = Base64.getDecoder().decode(dynamicSourceData.getBase64Bytes());
            return this.defineClass(dynamicSourceData.getClassName(), classData, 0, classData.length);
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        if (name.startsWith(this.packName)) {
            result = this.findClass(name);
            if (resolve) {
                this.resolveClass(result);
            }
        } else {
            result = super.loadClass(name, resolve);
        }
        return result;
    }
}

