/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.server.service;

import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.common.bean.NewsItem;
import ru.bitel.bgbilling.plugins.news.common.service.NewsService;
import ru.bitel.bgbilling.plugins.news.server.bean.NewsManager;
import ru.bitel.bgbilling.plugins.news.server.event.NewsModifiedEvent;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.news.common.service.NewsService")
public class NewsServiceImpl
extends AbstractService
implements NewsService {
    public News newsGet(int id) throws Exception {
        return (News)new NewsManager(this.getConnection()).get(id);
    }

    public int newsUpdate(News news) throws Exception {
        boolean isNew = news.getId() == 0;
        new NewsManager(this.getConnection()).update(news);
        EventProcessor.getInstance().request((QueueEvent)new NewsModifiedEvent(this.userId, news.getId(), isNew));
        return news.getId();
    }

    public List<News> newsList(Page page) throws Exception {
        return new NewsManager(this.getConnection()).list(page);
    }

    public List<News> newsListForContract(int contractId, Page page) throws Exception {
        return new NewsManager(this.getConnection()).getNewsList(this.context.getSetup(), page, contractId);
    }

    public void newsDelete(int id) throws Exception {
        new NewsManager(this.getConnection()).delete(id);
        EventProcessor.getInstance().request((QueueEvent)new NewsModifiedEvent(this.userId, id));
    }

    public SearchResult<NewsItem> newsSearch(Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        new NewsManager(this.getConnection()).search((SearchResult<NewsItem>)searchResult);
        return searchResult;
    }
}

