<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
      xmlns:fo="http://www.w3.org/1999/XSL/Format">
  	<xsl:output method="xml" indent="yes"/>
  	<xsl:template match="data">
    
    <!-- Сумма платежа: 120,00р. -->
    <xsl:variable name="param_summ" select="line[@n='1']/@text" />
	<!-- Номер договора -->
	<xsl:variable name="param_contract" select="line[@n='2']/@text" />
	<!-- Фамилия клиента -->
	<xsl:variable name="param_fio" select="line[@n='3']/@text" />
	<!-- Дата платежа -->
	<xsl:variable name="param_data" select="line[@n='4']/@text" />
	<!-- Организация -->
	<xsl:variable name="param_org" select="line[@n='5']/@text" />
	<!-- ФИО кассира (пользователя биллинга) -->
	<xsl:variable name="param_cashman" select="line[@n='6']/@text" />
	<!-- Тип платежа: СПД  № -->
	<xsl:variable name="param_paytype" select="line[@n='7']/@text" />
	<!-- *Сумма прописью: Сто двадцать рублей 00 коп -->
	<xsl:variable name="param_summtxt" select="line[@n='8']/@text" />
  
<fo:root>
	<fo:layout-master-set>
		<fo:simple-page-master master-name="Letter Page" page-width="8.5in" page-height="11in">
			<fo:region-body region-name="xsl-region-body" margin="0.5in" />
			<fo:region-before region-name="xsl-region-before" display-align="after" extent="0.5in"/>
			<fo:region-after region-name="xsl-region-after" display-align="before" extent="0.5in"/>
			<fo:region-start region-name="xsl-region-start" extent="0.5in"/>
			<fo:region-end region-name="xsl-region-end" extent="0.5in"/>
		</fo:simple-page-master>
	</fo:layout-master-set>
	<fo:page-sequence master-reference="Letter Page">
		<fo:static-content flow-name="xsl-region-before" font-size="12pt" font-family="Times">
			<fo:block>&#x00A0;</fo:block>
		</fo:static-content>
		<fo:static-content flow-name="xsl-region-after" font-size="12pt" font-family="Times">
			<fo:block>&#x00A0;</fo:block>
		</fo:static-content>
		<fo:static-content flow-name="xsl-region-start" font-size="12pt" font-family="Times">
			<fo:block>&#x00A0;</fo:block>
		</fo:static-content>
		<fo:static-content flow-name="xsl-region-end" font-size="12pt" font-family="Times">
			<fo:block>&#x00A0;</fo:block>
		</fo:static-content>
		<fo:flow flow-name="xsl-region-body" font-family="Times" font-size="12pt">
			<fo:block><fo:table table-layout="fixed" width="100%" border-collapse="collapse">
<fo:table-column column-width="7pt" column-number="1"/>
<fo:table-column column-width="35pt" column-number="2"/>
<fo:table-column column-width="20pt" column-number="3"/>
<fo:table-column column-width="45pt" column-number="4"/>
<fo:table-column column-width="45pt" column-number="5"/>
<fo:table-column column-width="45pt" column-number="6"/>
<fo:table-column column-width="45pt" column-number="7"/>
<fo:table-column column-width="45pt" column-number="8"/>
<fo:table-column column-width="60pt" column-number="9"/>
<fo:table-column column-width="7pt" column-number="10"/>
<fo:table-column column-width="7pt" column-number="11"/>
<fo:table-column column-width="55pt" column-number="12"/>
<fo:table-column column-width="45pt" column-number="13"/>
<fo:table-column column-width="60pt" column-number="14"/>
<fo:table-body>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="right">Унифицированная форма № КО-1</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="10pt" color="black" font-weight="bold" text-align="center" ><xsl:value-of select="$param_org"/></fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="4">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="right">Утверждена постановлением  Госкомстата</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center" font-family="sans-serif" font-size="8pt">организация</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="right">России от 18.08.98 №88</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center" font-family="sans-serif" font-size="10pt" font-weight="bold">КВИТАНЦИЯ</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="5" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" text-align="right"><fo:inline font-size="10pt" font-weight="bold"><xsl:value-of select="$param_org"/></fo:inline> </fo:block>
								</fo:table-cell><fo:table-cell border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="right">Форма</fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">по ОКУД</fo:block>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center" >Код</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" text-align="center" font-size="10pt" font-weight="bold">К ПРИХОДНОМУ КАССОВОМУ</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">организация</fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">по ОКПО</fo:block>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">310001</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center" font-family="sans-serif" font-size="10pt" font-weight="bold">ОРДЕРУ</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center" font-family="sans-serif" font-size="10pt"><xsl:value-of select="$param_data"/></fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="7" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="5">
									<fo:block font-family="sans-serif" text-align="center" font-size="8pt">структурное подразделение</fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">Принято от</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="10pt" font-weight="bold" text-align="center"><xsl:value-of select="$param_fio"/></fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="6">
									<fo:block font-family="sans-serif" font-size="10pt" font-weight="bold" text-align="center">ПРИХОДНЫЙ КАССОВЫЙ ОРДЕР</fo:block>
								</fo:table-cell><fo:table-cell border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Номер Документа</fo:block>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Дата составления</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">Основание</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="10pt" text-align="center" >ППО</fo:block>
								</fo:table-cell></fo:table-row>
	<fo:table-row>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif"><fo:inline font-size="8pt"><xsl:value-of select="$param_data"/></fo:inline> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="2" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" font-size="10pt" text-align="right" font-weight="bold"><xsl:value-of select="$param_paytype"/></fo:block>
		</fo:table-cell>
		<fo:table-cell border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" font-size="10pt" text-align="center" font-weight="bold"><xsl:value-of select="$param_contract"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	
	<fo:table-row>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell number-rows-spanned="2" border-top-style="solid" border-top-width="2.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Дебет</fo:block>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="4" border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="2.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" text-align="center" font-size="8pt">Кредит</fo:block>
		</fo:table-cell>
		<fo:table-cell number-rows-spanned="2" border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="2.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Сумма руб.коп.</fo:block>
		</fo:table-cell>
		<fo:table-cell number-rows-spanned="2" border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="2.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Код целевого назначения</fo:block>
		</fo:table-cell>
		<fo:table-cell number-rows-spanned="2" border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="2.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Номер договора</fo:block>
		</fo:table-cell>
		<fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="1">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="1">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
	</fo:table-row>
	
	<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Код структур. подразд.</fo:block>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Корресп. счёт.субсчёт</fo:block>
								</fo:table-cell><fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">Код аналитич. учёта</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">Сумма</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="10pt" text-align="center" font-weight="bold" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black" ><xsl:value-of select="$param_summ"/></fo:block>
								</fo:table-cell></fo:table-row>
	<fo:table-row>
		<fo:table-cell>
			<fo:block/>
		</fo:table-cell>
		<fo:table-cell border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" text-align="center"><fo:inline font-size="10pt"><xsl:value-of select="$param_summ"/></fo:inline> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif"> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-left-style="solid" border-left-width="1.000px" border-left-color="black" border-top-style="solid" border-top-width="1.000px" border-top-color="black" border-right-style="solid" border-right-width="1.000px" border-right-color="black" border-bottom-style="solid" border-bottom-width="2.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" text-align="center"><fo:inline font-size="10pt" font-weight="bold"><xsl:value-of select="$param_contract"/></fo:inline> </fo:block>
		</fo:table-cell>
		<fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
			<fo:block font-family="sans-serif"/>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block font-family="sans-serif"/>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
			<fo:block font-family="sans-serif" text-align="center" font-size="10pt"><xsl:value-of select="$param_summtxt"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	
	<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt">Принято от</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="6" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" text-align="center"><fo:inline font-size="10pt" font-weight="bold"><xsl:value-of select="$param_fio"/></fo:inline> </fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">В том числе:</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" text-align="center" font-size="8pt">прописью</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt">Основание</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="10pt" text-align="center" font-weight="bold">ППО <xsl:value-of select="$param_paytype"/></fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" font-size="10pt" text-align="center" font-weight="bold"><xsl:value-of select="$param_contract"/></fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">М.П. (штампа)</fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt">Сумма</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" text-align="center"><fo:inline font-size="10pt"><xsl:value-of select="$param_summ"/></fo:inline> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="4" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" text-align="center"><fo:inline font-size="10pt"><xsl:value-of select="$param_summtxt"/></fo:inline> </fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt" font-weight="bold">Главный бухгалтер</fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"    border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black" > </fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt">В том числе:</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">цифрами</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="4">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">прописью</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt">подпись</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt">Приложение</fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="5" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif"    border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black" > </fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" font-size="8pt" font-weight="bold">Главный бухгалтер</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">расшифровка подписи</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">подпись</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">расшифровка подписи</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt" font-weight="bold">Кассир</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif"    border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black" > </fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif" font-size="8pt" font-weight="bold">Кассир</fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black">
									<fo:block font-family="sans-serif" text-align="center" font-size="10pt"><xsl:value-of select="$param_cashman"/></fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">подпись</fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="2">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">подпись</fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">расшифровка подписи</fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" text-align="center" font-size="10pt" border-bottom-style="solid" border-bottom-width="1.000px" border-bottom-color="black" ><xsl:value-of select="$param_cashman"/></fo:block>
								</fo:table-cell></fo:table-row>
<fo:table-row>
								<fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell border-right-style="solid" border-right-width="1.000px" border-right-color="black">
									<fo:block font-family="sans-serif"/>
								</fo:table-cell><fo:table-cell>
									<fo:block font-family="sans-serif"> </fo:block>
								</fo:table-cell><fo:table-cell number-columns-spanned="3">
									<fo:block font-family="sans-serif" font-size="8pt" text-align="center">расшифровка подписи</fo:block>
								</fo:table-cell></fo:table-row>

</fo:table-body>
</fo:table>&#x00A0;</fo:block>
		</fo:flow>
	</fo:page-sequence>
</fo:root>
    
    
    
  </xsl:template>
</xsl:stylesheet>