/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider.CustomerParameterProvider;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider.CustomerParameterProviderUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class CustomerParameterProviderDaData
extends BGLogger
implements CustomerParameterProvider {
    private static final CustomerParameterProviderDaData INSTANCE = new CustomerParameterProviderDaData();
    private static final int DEFAULT_TIMEOUT_SECONDS = 3;
    private static final String DADATA_URL = "https://suggestions.dadata.ru/suggestions/api/4_1/rs/suggest/party";
    private final String apiKey = Setup.getSetup().get("dadata.api.key");
    private final HttpClient httpClient;

    private CustomerParameterProviderDaData() {
        if (Utils.isBlankString(this.apiKey)) {
            this.getLogger().warn("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d API_KEY \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 DaData \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            this.httpClient = null;
        } else {
            this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
        }
    }

    public static CustomerParameterProviderDaData getInstance() {
        return INSTANCE;
    }

    @Override
    public JSONObject searchDataByINN(String inn) throws Exception {
        return this.parseCompanyData(this.getCompanyData(inn));
    }

    @Override
    public JSONObject searchDataByOGRN(String ogrn) throws Exception {
        return this.parseCompanyData(this.getCompanyData(ogrn));
    }

    private JSONObject getCompanyData(String innOrOgrn) {
        if (!this.checkSourceCondition()) {
            throw new RuntimeException("\u041d\u0435 \u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043b\u044e\u0447 \u043a API \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430 DaData");
        }
        try {
            HttpResponse<String> response = this.httpClient.send(this.getHttpPOSTRequest(URI.create(DADATA_URL), innOrOgrn), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            if (response.statusCode() != 200) {
                throw new RuntimeException(String.format("DaData statusCode=%s, body=%s", response.statusCode(), response.body()));
            }
            return new JSONObject(response.body());
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject parseCompanyData(JSONObject raw) {
        JSONObject result = new JSONObject();
        JSONObject data = raw.optJSONArray("suggestions").optJSONObject(0).optJSONObject("data");
        JSONObject state = data.optJSONObject("state");
        result.put("isActive", state.optString("status").equals("ACTIVE"));
        result.put("regDate", (Object)state.optString("registration_date"));
        result.put("title", (Object)data.optJSONObject("name").optString("short_with_opf"));
        result.put("fullTitle", (Object)data.optJSONObject("name").optString("full_with_opf"));
        result.put("ogrn", (Object)data.optString("ogrn"));
        result.put("inn", (Object)data.optString("inn"));
        result.put("kpp", (Object)data.optString("kpp"));
        JSONObject address = data.optJSONObject("address");
        result.put("address", (Object)address.optString("value"));
        result.put("postIndex", (Object)"");
        JSONObject management = data.optJSONObject("management");
        JSONObject supervisor = new JSONObject();
        supervisor.put("name", (Object)management.optString("name"));
        supervisor.put("position", (Object)CustomerParameterProviderUtils.capitalizeFirstWordOnly(management.optString("post")));
        result.put("supervisor", (Object)supervisor);
        return result;
    }

    @Override
    public String getGuiTitle() {
        return "DaData";
    }

    private HttpRequest getHttpPOSTRequest(URI uri, String innOrOgrn) {
        if (Utils.isBlankString(innOrOgrn)) {
            throw new RuntimeException("\u041d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d \u0418\u041d\u041d \u0438\u043b\u0438 \u041e\u0413\u0420\u041d!");
        }
        JSONObject body = new JSONObject();
        body.put("query", (Object)innOrOgrn);
        HttpRequest request = HttpRequest.newBuilder().uri(uri).POST(HttpRequest.BodyPublishers.ofString(body.toString())).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "Token " + this.apiKey).build();
        this.getLogger().debug("HttpRequest = {}, Body = {}", (Object)request.toString(), (Object)body);
        return request;
    }

    @Override
    public boolean checkSourceCondition() {
        if (Utils.isBlankString(this.apiKey)) {
            return false;
        }
        return this.httpClient != null;
    }
}

