/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import java.nio.file.Path;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.signaltek.SignaltekFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.signaltek.SignaltekUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpertV3.VasexpertV3FileTitle;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpertV3.VasexpertV3Upload;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public abstract class SormTransferFiles
extends BGLogger {
    protected String login;
    protected String password;
    protected String host;
    protected int port;

    public SormTransferFiles(Preferences config) throws BGException {
        this.login = config.get("sorm.ftp.login");
        this.password = config.get("sorm.ftp.password");
        this.host = config.get("sorm.ftp.host");
        this.port = Utils.parseInt((String)config.get("sorm.ftp.port"));
        if (Utils.isBlankString((String)this.login) || Utils.isBlankString((String)this.password) || Utils.isBlankString((String)this.host)) {
            throw new BGMessageException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a FTP!");
        }
        if (this.port <= 0) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u043e\u0440\u0442!");
        }
        this.getLogger().info("Connect to host={}, port={}. login={}", new Object[]{this.host, this.port, this.login});
    }

    protected String getRemoteFilePath(UploadFiles uploadFiles, Path file, Upload versionUpload, Preferences config) {
        String remoteFilePath = uploadFiles.getPath(file);
        if (Utils.isBlankString((String)remoteFilePath)) {
            remoteFilePath = config.get("sorm.ftp.catalog");
        }
        if (Utils.isBlankString((String)remoteFilePath)) {
            remoteFilePath = this.getPathForFileOnFTP(file, versionUpload);
        }
        this.getLogger().debug("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u0434\u043b\u044f \u0444\u0430\u0439\u043b\u0430 \u043d\u0430 \u0443\u0434\u0430\u043b\u0451\u043d\u043d\u043e\u043c \u0441\u0435\u0440\u0432\u0435\u0440\u0435: {}", (Object)remoteFilePath);
        return remoteFilePath;
    }

    private String getPathForFileOnFTP(Path uploadFile, Upload versionUpload) {
        String fileName = uploadFile.getFileName().toString();
        String fileTitle = fileName.contains("_") ? fileName.substring(0, fileName.lastIndexOf("_")) : fileName;
        String pathToFile = null;
        if (versionUpload instanceof NorsiTransUpload) {
            pathToFile = NorsiTransFileTitle.getFTPDirectory(fileTitle);
        } else if (versionUpload instanceof VasexpertV3Upload) {
            pathToFile = VasexpertV3FileTitle.getFTPDirectory(fileTitle);
        } else if (versionUpload instanceof VasexpertUpload) {
            pathToFile = VasexpertFileTitle.getFTPDirectory(fileTitle);
        } else if (versionUpload instanceof SignaltekUpload) {
            pathToFile = SignaltekFileTitle.getFTPDirectory(fileTitle);
        }
        return Utils.isBlankString((String)pathToFile) ? "/" : pathToFile;
    }
}

