/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeries;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class CardSeriesManager {
    private final Connection con;
    private final String table;
    private final int mid;

    public CardSeriesManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        this.table = "card_series_" + mid;
    }

    public int addSeries(String title) throws BGException {
        int result = -1;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT id FROM " + this.table + " WHERE title=?");
            ps.setString(1, title);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                throw new BGException("\u0422\u0430\u043a\u0430\u044f \u0441\u0435\u0440\u0438\u044f \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            ps = this.con.prepareStatement("INSERT INTO " + this.table + " (title) VALUES (?)", 1);
            ps.setString(1, title);
            ps.executeUpdate();
            result = ServerUtils.lastInsertId((PreparedStatement)ps);
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int getSeriesId(String title) {
        int result = -1;
        try {
            String query = "SELECT id FROM " + this.table + " WHERE title=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public CardSeries getSeries(int id) {
        CardSeries result = null;
        try {
            String query = null;
            query = "SELECT series.id as series_id, series.title as series_title, series.free as series_free, card.* FROM " + this.table + " as series LEFT JOIN card_data_" + this.mid + " as card ON card.cs_id=series.id WHERE series.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getCardSeriesFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<CardSeries> getSeriesList() {
        ArrayList<CardSeries> result = new ArrayList<CardSeries>();
        try {
            String query = null;
            query = "SELECT series.id as series_id, series.title as series_title, series.free AS series_free, card.*, sact.title as sact_title, spay.title as spay_title, types.title as type_title, pattern.title as pattern_title FROM " + this.table + " as series LEFT JOIN card_data_" + this.mid + " as card ON card.cs_id=series.id LEFT JOIN service as sact ON sact.id=card.sid_act LEFT JOIN service as spay ON spay.id=card.sid_pay LEFT JOIN contract_payment_types as types ON types.id=card.pt LEFT JOIN contract_pattern as pattern ON pattern.id=card.pid  GROUP BY series.id ORDER BY series.id DESC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardSeries s = this.getCardSeriesFromRS(rs);
                s.setContractPatternTitle(rs.getString("pattern_title"));
                s.setPaymentTypeTitle(rs.getString("type_title"));
                s.setServiceActivateTitle(rs.getString("sact_title"));
                if (rs.wasNull()) {
                    s.setServiceActivateTitle("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                }
                s.setServiceBalanceTitle(rs.getString("spay_title"));
                if (rs.wasNull()) {
                    s.setServiceBalanceTitle("\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
                }
                result.add(s);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private CardSeries getCardSeriesFromRS(ResultSet rs) throws SQLException {
        return new CardSeries().setId(rs.getInt("series_id")).setTitle(rs.getString("series_title")).setFreeCard(rs.getInt("series_free")).setContractPatternId(rs.getInt("pid")).setPeriod(new Period((Date)rs.getDate("date1"), (Date)rs.getDate("date2"))).setPaymentTypeId(rs.getInt("pt")).setServiceActivate(rs.getInt("sid_act")).setServiceBalance(rs.getInt("sid_pay")).setCardSum(rs.getBigDecimal("summa"));
    }

    public String getSeriesTitle(int id) {
        try {
            String query = "SELECT series.title as series_title FROM " + this.table + " as series WHERE series.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                return rs.getString(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int updateSeries(CardSeries series) {
        try {
            String query = "UPDATE card_data_" + this.mid + " SET summa=?, date1=?, date2=?, sid_pay=?, sid_act=?, pid=?, pt=? WHERE cs_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setBigDecimal(1, series.getCardSum());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)series.getPeriod().getDateFrom()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)series.getPeriod().getDateTo()));
            ps.setInt(4, series.getServiceBalance());
            ps.setInt(5, series.getServiceActivate());
            ps.setInt(6, series.getContractPatternId());
            ps.setInt(7, series.getPaymentTypeId());
            ps.setInt(8, series.getId());
            int res = ps.executeUpdate();
            ps.close();
            return res;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void updateSeriesFree(int id) {
        try {
            int freeCount = 0;
            String query = "SELECT COUNT(*) FROM card_data_" + this.mid + " WHERE cs_id=? AND status=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.setInt(2, 0);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                freeCount = rs.getInt(1);
            }
            rs.close();
            ps.close();
            query = "UPDATE card_series_" + this.mid + " SET free=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, freeCount);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int deleteSeries(int id) {
        try {
            String query = null;
            query = "DELETE FROM " + this.table + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM card_data_" + this.mid + " WHERE cs_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            int res = ps.executeUpdate();
            ps.close();
            return res;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List<CardSeries> getNotEmptySeries() {
        ArrayList<CardSeries> result = new ArrayList<CardSeries>();
        try {
            String query = "SELECT * FROM " + this.table + " WHERE free>0";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CardSeries series = new CardSeries();
                series.setId(rs.getInt("id"));
                series.setTitle(rs.getString("title"));
                series.setFreeCard(rs.getInt("free"));
                result.add(series);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Set<Integer> getCardSeries(String cards) {
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            String query = "SELECT cs_id FROM card_data_" + this.mid + " WHERE id IN ( " + cards + " )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Long> getCardsFromSeries(int seriesId, int needCount) {
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            String query = "SELECT id FROM card_data_" + this.mid + " WHERE status=0 AND cs_id=? ORDER BY id LIMIT ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, seriesId);
            ps.setInt(2, needCount);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getLong(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

