/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.AddressObj;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.FiasCity;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class BaseLoadManager
extends BGLogger {
    protected static String FIAS_CITY_MAP = "fias_city_map";
    protected static String FIAS_STREET_MAP = "fias_street_map";
    protected static String ADDRESS_STREET = "address_street";
    protected static String FIAS_STREET_TEMP = "fias_street_temp";
    protected static String ADDRESS_CITY = "address_city";
    protected static String FIAS_HOUSE_TEMP = "fias_house_temp";
    protected static String FIAS_HOUSE_MAP = "fias_house_map";
    protected static String ADDRESS_HOUSE = "address_house";
    protected boolean PROFILE = true;
    protected final Connection con;

    public BaseLoadManager(Connection con) {
        this.con = con;
    }

    protected void exceptionLog(Exception ex) throws BGException {
        this.getLogger().error(((Object)((Object)this)).getClass().getName(), (Throwable)ex);
        throw new BGException((Throwable)ex);
    }

    protected ResultSet executeQuery(PreparedStatement ps) throws SQLException {
        long start = 0L;
        long stop = 0L;
        if (this.PROFILE) {
            start = System.currentTimeMillis();
        }
        ResultSet rs = ps.executeQuery();
        if (this.PROFILE) {
            stop = System.currentTimeMillis();
            this.getLogger().debug("[" + TimeUtils.formatDeltaTime((long)(stop - start)) + "]" + ps.toString());
        }
        return rs;
    }

    protected ResultSet executeQuery(Statement st, String query) throws SQLException {
        long start = 0L;
        long stop = 0L;
        if (this.PROFILE) {
            start = System.currentTimeMillis();
        }
        ResultSet rs = st.executeQuery(query);
        if (this.PROFILE) {
            stop = System.currentTimeMillis();
            this.getLogger().debug("[" + TimeUtils.formatDeltaTime((long)(stop - start)) + "]" + query);
        }
        return rs;
    }

    protected <T extends AddressObj> T loadAddressObjFromRs(T obj, ResultSet rs) throws SQLException {
        String shortname = rs.getString("shortname");
        String offname = rs.getString("offname");
        obj.setId(rs.getInt("id"));
        obj.setShortname(shortname);
        obj.setOffname(offname);
        obj.setCode(rs.getString("code"));
        obj.setAoguid(rs.getString("aoguid"));
        obj.setLevel(rs.getString("level"));
        obj.setPostalcode(rs.getString("postalcode"));
        obj.setRegion(rs.getString("region"));
        obj.setParentguid(rs.getString("parentguid"));
        return obj;
    }

    protected FiasCity loadCityFromRs(ResultSet rs) throws SQLException, BGException {
        FiasCity city = this.loadAddressObjFromRs(new FiasCity(), rs);
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT id, code, aoguid, level, shortname, offname, postalcode, region, parentguid FROM " + FIAS_CITY_MAP + " WHERE aoguid=?");
            String parentguid = city.getParentguid();
            ArrayList<FiasCity> parents = new ArrayList<FiasCity>();
            while (!Utils.isEmptyString((String)parentguid)) {
                ps.setString(1, parentguid);
                ResultSet rsParent = ps.executeQuery();
                if (rsParent.next()) {
                    FiasCity parent = this.loadAddressObjFromRs(new FiasCity(), rsParent);
                    parents.add(parent);
                    parentguid = parent.getParentguid();
                } else {
                    parentguid = "";
                }
                rsParent.close();
            }
            ps.close();
            Collections.reverse(parents);
            city.setParents(parents);
        }
        catch (SQLException e) {
            this.exceptionLog(e);
        }
        return city;
    }

    public void clearFiasTable() throws Exception {
        try (Statement st = this.con.createStatement();){
            this.getLogger().info("clear fias table..");
            int c = st.executeUpdate("delete from fias_city_map where id<>-1 AND id NOT IN (SELECT id FROM address_city)");
            this.getLogger().info("clear " + c + " city");
            c = st.executeUpdate("delete from fias_street_map where id NOT IN (SELECT id FROM address_street)");
            this.getLogger().info("clear " + c + " street");
            c = st.executeUpdate("delete from fias_house_map WHERE id NOT IN (SELECT id FROM address_house)");
            this.getLogger().info("clear " + c + " house");
        }
    }
}

