/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.util.Date;
import java.util.Set;
import org.slf4j.event.Level;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.IpRangeRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

public class InetConnectionAutoRuntime
extends InetConnectionRuntime {
    public InetConnectionAutoRuntime(Accounting accounting, InetServRuntime inetServRuntime, InetConnection connection, InetSession session) throws BGException {
        super(accounting, false, inetServRuntime, connection, session);
    }

    @Override
    public void setConnection(InetConnection connection) {
        super.setConnection(connection);
    }

    public void setRangeSets(InetServ inetServ) {
        this.rangeSets = new IpRangeRuntime[]{new IpRangeRuntime(inetServ.getAddressFrom(), inetServ.getAddressTo(), this)};
    }

    @Override
    public boolean tryFinish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, long now, long nowMillis) throws BGException {
        assert (this.inetServRuntime.isHeldByCurrentThread());
        long lastFlowTime = this.lastFlowTime;
        Integer deviceId = this.inetServRuntime.getInetServ().getDeviceId();
        InetDeviceRuntime deviceRuntime = accounting.deviceMap.get(deviceId);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("tryFinish(): deviceId = {}; connection.getConnectionStatus() = {}", (Object)deviceId, (Object)this.connection.getConnectionStatus());
        }
        if (this.connection.getConnectionStatus() != 3) {
            long time = now - deviceRuntime.connectionAutoCloseTimeout;
            if (lastFlowTime > time || lastFlowTime == -1L) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("tryFinish(): skip (1) lastFlowTime = {}; time = {}; deviceRuntime.connectionAutoCloseTimeout = {}", new Object[]{lastFlowTime, time, deviceRuntime.connectionAutoCloseTimeout});
                }
                return false;
            }
            time = System.currentTimeMillis() - this.connectionStartTime;
            if (deviceRuntime.connectionAutoMinDurationMillis > 0L && time < deviceRuntime.connectionAutoMinDurationMillis) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("tryFinish(): skip (2) time = {}; deviceRuntime.connectionAutoMinDurationMillis = {}", (Object)time, (Object)deviceRuntime.connectionAutoMinDurationMillis);
                }
                return false;
            }
            this.getLogger().debug("tryFinish(): Close and finish connection(a) by sessionCloseTimeout and connectionAutoMinDuration");
        } else {
            this.getLogger().debug("tryFinish(): Close and finish connection(a) by status closed");
        }
        InetConnection.setType((InetConnection)this.connection, (int)4, (boolean)true);
        this.finish(accounting, connectionSet, balanceDao, false, nowMillis, false);
        return true;
    }

    @Override
    public void finish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, boolean needStop, long millis, boolean force) throws BGException {
        boolean check;
        assert (this.inetServRuntime.isHeldByCurrentThread());
        long lastFlowTimeMillis = this.lastFlowTime * 1000L;
        if (force && !needStop) {
            this.getLogger().info("finish(): (1) Finishing auto session now with lastFlowTime = {}", (Object)new Date(lastFlowTimeMillis));
            this.sessionStop = new Date(millis);
        } else {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("finish(): (2) lastFlowTimeMillis = {}; sessionStartTime = {}", (Object)lastFlowTimeMillis, (Object)this.sessionStartTime);
            }
            if (lastFlowTimeMillis <= this.sessionStartTime) {
                this.getLogger().info("finish(): (3) Finishing auto session now with lastFlowTime = {}", (Object)new Date(lastFlowTimeMillis));
                this.sessionStop = new Date(millis);
            } else {
                this.getLogger().info("finish(): (4) Finishing auto session with lastFlowTime = {}", (Object)new Date(lastFlowTimeMillis));
                this.sessionStop = new Date(lastFlowTimeMillis);
            }
        }
        InetConnection connection = this.connection;
        boolean bl = check = needStop || connection.getConnectionStatus() < 3;
        if (accounting.sessionFinish(connectionSet, balanceDao, this, true, check, force)) {
            connection.setConnectionStatus(3);
            connectionSet.commit();
        }
    }

    @Override
    public boolean processAccessCode(Accounting application, ConnectionSet connectionSet, int accessCode) throws BGException {
        if (this.inetServRuntime.getParentInetServ(application).getDeviceState() == InetServState.STATE_ENABLE.getCode()) {
            if (accessCode != AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
                ConnectionLog.log(this, Level.INFO, "Found error " + accessCode);
                if (accessCode != AccessCode.TARIFF_NOT_FOUND.getCode() && accessCode != AccessCode.PRICE_NOT_FOUND.getCode() || application.servDisableOnTariffError) {
                    if (!this.kill) {
                        InetServ parentInetServ = this.inetServRuntime.getParentInetServ(application);
                        ConnectionLog.log(this, Level.INFO, "Sending event to disable serv...");
                        EventProcessor ep = EventProcessor.getInstance();
                        ep.publish((Event)new InetSaStateModifyEvent(application.moduleId, 0, parentInetServ, InetServState.STATE_DISABLE.getCode(), accessCode));
                        this.kill = true;
                    } else {
                        ConnectionLog.log(this, Level.INFO, "Already sent event to disable serv.");
                    }
                }
                return true;
            }
        } else if (accessCode == AccessCode.AUTHORIZATION_SUCCEEDED.getCode()) {
            if (!this.kill) {
                InetServ parentInetServ = this.inetServRuntime.getParentInetServ(application);
                ConnectionLog.log(this, Level.INFO, "Sending event to enable serv...");
                EventProcessor ep = EventProcessor.getInstance();
                ep.publish((Event)new InetSaStateModifyEvent(application.moduleId, 0, parentInetServ, InetServState.STATE_ENABLE.getCode(), accessCode));
                this.kill = true;
            } else {
                ConnectionLog.log(this, Level.INFO, "Already sent event to enable serv.");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean processInetOptions(InetApplication application, Set<Integer> newOptions, String source) throws BGException {
        if (!this.inetOptions.equals(newOptions)) {
            this.inetOptions = newOptions;
            ConnectionLog.log(this, Level.INFO, "Sending event to modify serv options to: " + Utils.toString(newOptions));
            InetSaOptionsModifyEvent inetSaOptionsModifyEvent = new InetSaOptionsModifyEvent(application.moduleId, 0, this.inetServRuntime.getParentInetServ(application), newOptions);
            inetSaOptionsModifyEvent.setSource((String)(source != null ? source + ":" : "") + InetConnectionAutoRuntime.class.getSimpleName());
            EventProcessor.getInstance().publish((Event)inetSaOptionsModifyEvent);
            return true;
        }
        return false;
    }
}

