/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.common.TimeUtils;

public class LicenseLocalDao
extends AbstractDao<LicenseData> {
    public LicenseLocalDao(Connection con) {
        super(con, "license", 0);
    }

    public LicenseData getLicenseData(int licenseId) throws SQLException {
        return (LicenseData)this.getById(licenseId);
    }

    public List<LicenseData> getLicenseDataList() throws SQLException {
        return this.list("", "dt", new Object[0]);
    }

    public void deleteLicenseData(int licenseId) throws SQLException {
        this.delete("id=?", new Object[]{licenseId});
    }

    public void activateLicenseData(int licenseId) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET active=(id=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, licenseId);
            ps.executeUpdate();
        }
    }

    protected LicenseData getFromRS(ResultSet rs) throws SQLException {
        return new LicenseData().setId(rs.getInt("id")).setActive(rs.getBoolean("active")).setCreateDate(rs.getTimestamp("dt")).setCount(rs.getInt("count")).setStorage(Storage.DATABASE).setHash(rs.getString("hash")).setEncryptData(rs.getString("encryptData")).setPlainData(rs.getString("plainData"));
    }

    protected void updateImpl(LicenseData licenseLocalData) throws SQLException {
        Objects.requireNonNull(licenseLocalData);
        String query = "INSERT INTO " + this.tableName + " SET id=?, active=?, dt=?, count=?, hash=?, encryptData=?, plainData=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, licenseLocalData.getId());
            ps.setBoolean(index++, licenseLocalData.isActive());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)licenseLocalData.getCreateDate()));
            ps.setInt(index++, licenseLocalData.getCount());
            ps.setString(index++, licenseLocalData.getHash());
            ps.setString(index++, licenseLocalData.getEncryptData());
            ps.setString(index++, licenseLocalData.getPlainData());
            ps.executeUpdate();
        }
    }
}

