/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.bean.emuns.BGEntityType;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskStatus;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Idable;

public class BGFutureTaskDao
extends AbstractIdDao<BGFutureTask> {
    public BGFutureTaskDao(Connection con) {
        super(con, 0, "task_future");
    }

    public List<BGFutureTask> list(int moduleId, BGFutureTaskType futureTaskType, BGEntityType entityType, int entityId, BGFutureTaskStatus status) throws SQLException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(moduleId);
        params.add(futureTaskType.name());
        params.add(entityType.name());
        params.add(entityId);
        if (status != null && status != BGFutureTaskStatus.ALL) {
            params.add(status.getCode());
        }
        return this.list("module_id=? AND type=? AND entity_type=? AND entity_id=?" + (status == BGFutureTaskStatus.ALL ? "" : " AND task_status=?"), "start_time", params.toArray());
    }

    public void cancel(BGFutureTaskType futureTaskType, int id) throws SQLException {
        this.updateStatus(futureTaskType, id, BGFutureTaskStatus.CANCEL);
    }

    public void cancel(BGFutureTaskType futureTaskType, List<Integer> ids) throws SQLException {
        for (int id : ids) {
            this.cancel(futureTaskType, id);
        }
    }

    public void updateStatus(BGFutureTaskType futureTaskType, int id, BGFutureTaskStatus status) throws SQLException {
        Objects.requireNonNull(futureTaskType);
        Objects.requireNonNull(status);
        String query = "UPDATE " + this.tableName + " SET task_status=? WHERE type=? AND id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, status.getCode());
            ps.setString(index++, futureTaskType.name());
            ps.setInt(index++, id);
            ps.executeUpdate();
        }
    }

    public void delete(BGFutureTaskType futureTaskType, int id) throws SQLException {
        this.delete("type=? AND id=?", new Object[]{futureTaskType.name(), id});
    }

    public void delete(BGFutureTaskType futureTaskType, List<Integer> ids) throws SQLException {
        Objects.requireNonNull(ids);
        if (ids.isEmpty()) {
            return;
        }
        this.delete("type=? AND id IN ( " + Utils.toString(ids) + " )", new Object[]{futureTaskType.name()});
    }

    protected BGFutureTask getFromRS(ResultSet rs) throws SQLException {
        return BGFutureTask.builder().setId(rs.getInt("id")).setStartTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("start_time"))).setModuleId(rs.getInt("module_id")).setType(BGFutureTaskType.valueOf(rs.getString("type"))).setStatus(BGFutureTaskStatus.getBGFutureTaskStatusByCode(rs.getInt("task_status"))).setEntityType(BGEntityType.valueOf((String)rs.getString("entity_type"))).setEntityId(rs.getInt("entity_id")).setData(rs.getString("data")).setCreateTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("create_time"))).setCreateUserId(rs.getInt("create_user_id")).build();
    }

    protected void updateImpl(BGFutureTask futureTask) throws SQLException {
        boolean update;
        Objects.requireNonNull(futureTask);
        boolean bl = update = futureTask.getId() > 0;
        if (!update) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            String query = "SELECT id FROM " + this.tableName + " WHERE start_time=? AND module_id=? AND type=? AND entity_type=? AND entity_id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)futureTask.getStartTime()));
                ps.setInt(index++, futureTask.getModuleId());
                ps.setString(index++, futureTask.getType().name());
                ps.setString(index++, futureTask.getEntityType().name());
                ps.setInt(index++, futureTask.getEntityId());
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        ids.add(rs.getInt("id"));
                    }
                }
            }
            if (!ids.isEmpty()) {
                query = "UPDATE " + this.tableName + " SET task_status=3 WHERE id IN ( " + Utils.toString(ids) + " )";
                ps = this.con.prepareStatement(query);
                try {
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        }
        String querySet = "start_time=?, module_id=?, type=?, task_status=?, entity_type=?, entity_id=?, data=?, create_time=?, create_user_id=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)futureTask, querySet);){
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)futureTask.getStartTime()));
            ps.setInt(index++, futureTask.getModuleId());
            ps.setString(index++, futureTask.getType().name());
            ps.setInt(index++, futureTask.getStatus().getCode());
            ps.setString(index++, futureTask.getEntityType().name());
            ps.setInt(index++, futureTask.getEntityId());
            ps.setString(index++, futureTask.getData());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)futureTask.getCreateTime()));
            ps.setInt(index++, futureTask.getCreateUserId());
            this.executeUpdate(futureTask, index, ps);
        }
    }

    public List<BGFutureTask> listForRun() throws SQLException {
        return this.list("start_time < NOW() AND task_status=1", "start_time", new Object[0]);
    }

    public void deleteOld(BGFutureTaskType futureTaskType, int days) throws SQLException {
        this.delete("type=? AND start_time<?", new Object[]{futureTaskType.name(), TimeUtils.convertLocalDateToSqlDate((LocalDate)LocalDate.now().minusDays(days))});
    }
}

