/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ContractServiceDao
extends AbstarctDaoConstant {
    public ContractServiceDao(Connection con) {
        super(con, "contract_service", 0);
    }

    public List<IdTitle> getContractServiceTitles(int contractId, int moduleId) throws SQLException {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        String query = "SELECT DISTINCT t1.sid, t2.title FROM " + this.tableName + " AS t1, service AS t2  WHERE t1.cid=? AND t1.sid=t2.id AND t2.mid=? ORDER BY t2.title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(new IdTitle(rs.getInt(1), rs.getString(2)));
                }
            }
        }
        return result;
    }

    public List<ContractService> getContractServiceList(int contractId, int moduleId) throws SQLException {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        String query = "SELECT " + this.tableName + ".*, service.title FROM " + this.tableName + " INNER JOIN service ON " + this.tableName + ".sid=service.id  WHERE cid=? AND service.mid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, true));
                }
            }
        }
        return result;
    }

    public List<ContractService> getContractServiceList(int contractId, Calendar date) throws SQLException {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND ( ? IS NULL OR ( (date1<=?) AND (date2 IS NULL OR date2>=?) ) ) ORDER BY date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            java.sql.Date sqlDate = TimeUtils.convertCalendarToSqlDate(date);
            ps.setInt(index++, contractId);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, false));
                }
            }
        }
        return result;
    }

    public List<ContractService> getContractServiceList(int contractId, int moduleId, Date onDate) throws SQLException {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        String query = "SELECT * FROM " + this.tableName + " AS cs INNER JOIN service ON cs.sid=service.id WHERE cs.cid=? AND (? IS NULL OR ((cs.date1<=?) AND (cs.date2 IS NULL OR cs.date2>=?))) AND service.mid=? ORDER BY cs.date1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(onDate);
            ps.setInt(index++, contractId);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setInt(index++, moduleId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, false));
                }
            }
        }
        return result;
    }

    public Set<Integer> getContractServiceSet(int contractId, Date onDate) throws SQLException {
        HashSet<Integer> result = new HashSet<Integer>();
        this.getContractServiceList(contractId, TimeUtils.convertDateToCalendar(onDate)).forEach(cs -> result.add(cs.getServiceId()));
        return result;
    }

    public ContractService getContractServiceById(int id) throws SQLException {
        ContractService result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs, false);
                }
            }
        }
        return result;
    }

    public void updateContractService(ContractService contractService) throws SQLException {
        Objects.requireNonNull(contractService, "contractService must be not null");
        boolean update = contractService.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET cid=?, sid=?, date1=?, date2=?, comment=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, contractService.getContractId());
            ps.setInt(index++, contractService.getServiceId());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(contractService.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(contractService.getDateTo()));
            ps.setString(index++, contractService.getComment());
            if (update) {
                ps.setInt(index++, contractService.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractService.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public void deleteContractService(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void deleteContractService(int contractId, int moduleId) throws SQLException {
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        String query = "SELECT csrv.id FROM service AS srv  LEFT JOIN " + this.tableName + " AS csrv ON csrv.sid=srv.id  WHERE srv.mid=? AND csrv.cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, moduleId);
            ps.setInt(index++, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    idlist.add(rs.getInt(1));
                }
            }
        }
        if (Utils.notEmptyCollection(idlist)) {
            query = "DELETE FROM " + this.tableName + " WHERE id IN (" + Utils.toString(idlist) + ")";
            ps = this.con.prepareStatement(query);
            try {
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    public void deleteContractService(List<Integer> ids) throws SQLException {
        Objects.requireNonNull(ids, "ids must be not null");
        if (Utils.isEmptyCollection(ids)) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE id IN (" + Utils.toString(ids) + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
    }

    private ContractService getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        return ContractService.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setServiceId(rs.getInt("sid")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setComment(rs.getString("comment")).setServiceTitle(titleLoad ? rs.getString("title") : "").build();
    }

    public List<ContractService> getContractServiceList(int contractId, List<Integer> serviceIds, Calendar date1, Calendar date2) throws SQLException {
        Objects.requireNonNull(serviceIds, "serviceIds must be not null");
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        if (Utils.isEmptyCollection(serviceIds)) {
            return result;
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE cid=? AND sid IN (" + Utils.toString(serviceIds) + ") AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(date2)>=TO_DAYS(?))";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate(date1));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate(date2));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, false));
                }
            }
        }
        return result;
    }
}

