/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import bitel.billing.module.admin.resource.CategoryEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.table.tree.DefaultTreeTableModel;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.common.table.tree.TreeTableModel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public abstract class ResourceCategoriesTreePanel
extends BGPanel {
    protected String actionPrefix;
    protected String currentId;
    private DefaultTreeTableModel<DataTreeNode> model;
    private JTreeTable dataTree;
    protected CategoryEditor editorPanel;
    protected boolean editMode;

    public ResourceCategoriesTreePanel(boolean editMode) {
        this.editMode = editMode;
        this.init();
        this.jbInit();
    }

    protected abstract void init();

    private void jbInit() {
        DataTreeNode root = new DataTreeNode();
        root.title = "\u0412\u0441\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438";
        DefaultTreeTableModel.GetTreeNodeFromElement<DataTreeNode> parser = new DefaultTreeTableModel.GetTreeNodeFromElement<DataTreeNode>(this){

            @Override
            public DataTreeNode getFromElement(Element el) {
                DataTreeNode result = new DataTreeNode();
                result.id = Utils.parseInt(el.getAttribute("id"), -1);
                result.title = el.getAttribute("title");
                result.comment = el.getAttribute("comment");
                result.loaded = true;
                return result;
            }
        };
        this.model = this.editMode ? new DefaultTreeTableModel<DataTreeNode>(root, new String[]{"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"}, new Class[]{TreeTableModel.class, String.class}, parser) : new DefaultTreeTableModel<DataTreeNode>(root, new String[]{"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f"}, new Class[]{TreeTableModel.class}, parser);
        this.dataTree = new JTreeTable(this.model);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.dataTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editorPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.setVisible(false);
        this.editorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                ResourceCategoriesTreePanel.this.setData();
            }
        });
        this.dataTree.getTree().setSelectionPath(new TreePath(root));
        ClientUtils.addShowCodeListener(this.dataTree, this.model);
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.editorPanel.init(module, mid);
    }

    @Override
    public void setData() {
        DataTreeNode selectedNode = this.model.getSelectedNode();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.actionPrefix + "Table");
        request.setAttribute("mid", this.getModuleId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.trySetDocument(doc);
        }
        if (selectedNode != null) {
            this.dataTree.getTree().setSelectionPath(new TreePath(selectedNode));
        }
    }

    @Override
    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus(doc)) {
            Node info = XMLUtils.selectNode(doc, "//data");
            this.model.load(info, this.currentId, true);
            ResourceCategoriesTreePanel.expandNode(this.dataTree.getTree(), this.model.getRoot());
        }
    }

    private static void expandNode(JTree tree, TreeNode<?> start) {
        if (start.child != null) {
            for (TreeNode n : start.child) {
                if (n.isLeaf()) continue;
                TreePath tp = new TreePath(n.getPath());
                tree.expandPath(tp);
                ResourceCategoriesTreePanel.expandNode(tree, n);
            }
        }
    }

    @Override
    public void editItem() {
        DataTreeNode node = this.model.getSelectedNode();
        if (node == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        this.editorPanel.setId(node.id);
        this.editorPanel.trySetData();
        this.editorPanel.setVisible(true);
    }

    @Override
    public void newItem() {
        DataTreeNode node = this.model.getSelectedNode();
        if (node == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0443\u044e \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
            return;
        }
        this.editorPanel.setId(0);
        this.editorPanel.setParentId(node.id);
        this.editorPanel.trySetData();
        this.editorPanel.setVisible(true);
    }

    @Override
    public void deleteItem() {
        DataTreeNode node = this.model.getSelectedNode();
        if (node == null || 0 == node.id) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            return;
        }
        if (node.getChildCount() > 0) {
            ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
            return;
        }
        if (!ClientUtils.confirmDelete(node.title)) {
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.actionPrefix + "Delete");
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", String.valueOf(node.id));
        if (ClientUtils.checkStatus(this.getDocument(request))) {
            this.setData();
        }
    }

    public String getSelectedId() {
        String result = null;
        DataTreeNode node = this.model.getSelectedNode();
        if (node != null) {
            result = String.valueOf(node.id);
        }
        return result;
    }

    public void setSelectedId(int id) {
        DataTreeNode root = (DataTreeNode)this.model.getRoot();
        DataTreeNode selectedNode = null;
        selectedNode = root.id == id ? root : this.getSelectedNode(root, id);
        if (selectedNode != null) {
            this.dataTree.getTree().setSelectionPath(new TreePath(this.model.getPathToRoot(selectedNode)));
        }
    }

    private DataTreeNode getSelectedNode(DataTreeNode node, int id) {
        int childs = node.getChildCount();
        for (int i = 0; i < childs; ++i) {
            DataTreeNode subnode;
            if (((DataTreeNode)node.getChild((int)i)).id == id) {
                return (DataTreeNode)node.getChild(i);
            }
            if (((DataTreeNode)node.getChild(i)).getChildCount() <= 0 || (subnode = this.getSelectedNode((DataTreeNode)node.getChild(i), id)) == null) continue;
            return subnode;
        }
        return null;
    }

    public JTreeTable getTree() {
        return this.dataTree;
    }

    private static class DataTreeNode
    extends TreeNode<DataTreeNode> {
        protected static final Icon folderIcon = ClientUtils.getIcon("node.png");
        protected static final Icon leafIcon = ClientUtils.getIcon("leaf.png");
        private String title;
        private String comment;

        private DataTreeNode() {
        }

        @Override
        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.title;
                }
                case 1: {
                    return this.comment;
                }
            }
            return null;
        }

        @Override
        public Icon getIcon() {
            if (this.getChildCount() <= 0) {
                return leafIcon;
            }
            return folderIcon;
        }
    }
}

