/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class ContractNoteDao
extends AbstractIdDao<ContractNote> {
    public ContractNoteDao(Connection con) {
        super(con, 0, "contract_comment");
    }

    protected ContractNote getFromRS(ResultSet rs) throws SQLException {
        return ContractNote.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setDateTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("dt"))).setUserId(rs.getInt("uid")).setTitle(rs.getString("subject")).setComment(rs.getString("comment")).setVisible(rs.getBoolean("visibled")).build();
    }

    protected void updateImpl(ContractNote note) throws SQLException {
        String querySet = "subject=?, comment=?, uid=?, visibled=?, dt=?, cid=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)note, querySet);){
            int index = 1;
            ps.setString(index++, note.getTitle());
            ps.setString(index++, note.getComment());
            ps.setInt(index++, note.getUserId());
            ps.setBoolean(index++, note.isVisible());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)(note.getDateTime() == null ? LocalDateTime.now() : note.getDateTime())));
            ps.setInt(index++, note.getContractId());
            this.executeUpdate((Id)note, index, ps);
        }
    }

    public List<ContractNote> list(int contractId, boolean onlyForCustomer) throws SQLException {
        return this.list("cid=? " + (onlyForCustomer ? " AND visibled=true" : ""), "dt DESC", new Object[]{contractId});
    }
}

