/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.AbstractAddressDao;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class HouseDao
extends AbstractAddressDao<House> {
    public HouseDao(Connection con) {
        super(con, "address_house");
    }

    @Override
    protected House newBean() {
        return new House();
    }

    protected House getFromRS(ResultSet rs) throws SQLException {
        return new House().setId(rs.getInt("id")).setArea(new IdTitle().setId(rs.getInt("areaid"))).setQuarter(new IdTitle().setId(rs.getInt("quarterid"))).setStreet(new IdTitle().setId(rs.getInt("street_id"))).setHouse(rs.getInt("house")).setFrac(rs.getString("frac")).setPostIndex(rs.getString("box_index")).setAmount(rs.getInt("amount")).setPodCount(rs.getInt("pod_count")).setComment(rs.getString("comment"));
    }

    private House getHouse(ResultSet rs) throws SQLException {
        House house = this.getFromRS(rs).setCountry(new IdTitle(rs.getInt("country.id"), rs.getString("country.title"))).setCity(new IdTitle(rs.getInt("city.id"), rs.getString("city.title")));
        house.getArea().setTitle(rs.getString("area.title"));
        house.getStreet().setTitle(rs.getString("street.title"));
        house.getQuarter().setTitle(rs.getString("quarter.title"));
        return house;
    }

    protected void updateImpl(House house) throws BGException, SQLException {
        if (house.optStreet().map(a -> a.getId()).orElse(-1) < 0) {
            throw new BGException("house.street.id < 0");
        }
        if (house.getHouse() < 0 || house.getAmount() == -1) {
            throw new BGException("house.getHouse() < 0");
        }
        if (house.getAmount() < 0) {
            throw new BGException("house.getAmount() < 0");
        }
        int houseId = 0;
        if (house.getId() > 0) {
            House curHouse = this.get(house.getId());
            if (curHouse != null) {
                houseId = curHouse.getId();
            }
        } else {
            houseId = this.get(house.getStreet().getId(), house.getHouse(), house.getFrac());
        }
        if (houseId > 0 && house.getId() != houseId) {
            throw new BGMessageException("\u0414\u043e\u043c \u0443\u0436\u0435 \u0438\u043c\u0435\u0435\u0442\u0441\u044f");
        }
        boolean update = houseId > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + "address_house SET areaid=?, quarterid=?, street_id=?, house=?, frac=?, box_index=?, amount=?, comment=?, pod_count=?" + (!update && house.getId() > 0 ? ", id=?" : "") + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, house.getArea().getId());
            ps.setInt(index++, house.getQuarter().getId());
            ps.setInt(index++, house.getStreet().getId());
            ps.setInt(index++, house.getHouse());
            ps.setString(index++, house.getFrac());
            ps.setString(index++, house.getPostIndex());
            ps.setInt(index++, house.getAmount());
            ps.setString(index++, house.getComment());
            ps.setInt(index++, house.getPodCount());
            if (!update && house.getId() > 0) {
                ps.setInt(index++, house.getId());
            }
            if (update) {
                ps.setInt(index++, house.getId());
            }
            ps.executeUpdate();
            if (!update) {
                house.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public House get(int id) throws BGException {
        House house = null;
        String query = "SELECT SQL_CALC_FOUND_ROWS house.*, country.id, country.title, city.id, city.title, area.title, street.title, quarter.title FROM " + this.tableName + " as house LEFT JOIN address_street as street ON street.id=house.street_id LEFT JOIN address_area as area ON area.id=house.areaid LEFT JOIN address_quarter as quarter ON quarter.id=house.quarterid LEFT JOIN address_city AS city ON city.id=street.cityid LEFT JOIN address_country AS country ON country.id=city.country_id WHERE house.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    house = this.getHouse(rs);
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return house;
    }

    public House get(String houseFrac, int streetId) throws BGException {
        Object[] hf = House.getHouseAndFrac((String)houseFrac);
        return (House)super.get("street_id=? AND house=? AND frac=?", streetId, (Integer)hf[0], (String)hf[1]);
    }

    private int get(int streetId, int house, String frac) throws SQLException {
        int index = 1;
        int houseId = 0;
        StringBuffer query = new StringBuffer();
        query.append("SELECT id FROM " + this.tableName + " WHERE street_id=? AND house=?");
        if (frac.startsWith("/")) {
            query.append(" AND ( frac=? OR frac=? )");
        } else {
            query.append(" AND frac=? ");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(index++, streetId);
            ps.setInt(index++, house);
            ps.setString(index++, frac);
            if (frac.startsWith("/")) {
                ps.setString(index++, frac.substring(1));
            }
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    houseId = rs.getInt(1);
                }
            }
        }
        return houseId;
    }

    public List<House> list(int cityId, int areaId, int streetId, int quarterId, int house, String frac, Page page) throws BGException {
        ArrayList<House> arrayList;
        block23: {
            ArrayList<House> result = new ArrayList<House>();
            boolean useCity = cityId > 0;
            boolean useStreet = streetId > 0;
            boolean useArea = areaId > 0;
            boolean useQuarter = quarterId > 0;
            boolean useHouse = house >= 0;
            boolean useFrac = Utils.notBlankString((String)frac);
            String query = "SELECT SQL_CALC_FOUND_ROWS house.*, country.id, country.title, city.id, city.title, area.title, street.title, quarter.title FROM " + this.tableName + " as house LEFT JOIN address_area as area ON area.id=house.areaid LEFT JOIN address_quarter as quarter ON quarter.id=house.quarterid LEFT JOIN address_street as street ON street.id=house.street_id LEFT JOIN address_city AS city ON city.id=street.cityid LEFT JOIN address_country AS country ON country.id=city.country_id WHERE true " + (useStreet ? "AND house.street_id=? " : "") + (useCity ? "AND street.cityid=? " : "") + (useArea ? "AND house.areaid=? " : "") + (useQuarter ? "AND house.quarterid=? " : "") + (useHouse ? "AND house.house=? " : "") + (useFrac ? "AND (house.frac=? OR house.frac=?) " : "") + "ORDER BY country.title, city.title, area.title, quarter.title, street.title, house.house, house.frac" + this.sqlLimit(page);
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                int index = 1;
                if (useStreet) {
                    ps.setInt(index++, streetId);
                }
                if (useCity) {
                    ps.setInt(index++, cityId);
                }
                if (useArea) {
                    ps.setInt(index++, areaId);
                }
                if (useQuarter) {
                    ps.setInt(index++, quarterId);
                }
                if (useHouse) {
                    ps.setInt(index++, house);
                }
                if (useFrac) {
                    ps.setString(index++, frac);
                    ps.setString(index++, frac.matches("^/[0-9]+$") ? frac.substring(1) : frac);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(this.getHouse(rs));
                    }
                    if (page != null) {
                        page.setRecordCount(ServerUtils.foundRows(this.con));
                    }
                }
                arrayList = result;
                if (ps == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            ps.close();
        }
        return arrayList;
    }

    public void searchHouseList(SearchResult<House> searchResult, int areaId, int quarterId, int streetId, String houseFrac) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List list = searchResult.getList();
            int house = Utils.parseInt((String)AddressUtils.getHouse(houseFrac), (int)-1);
            String frac = AddressUtils.getHouseFrac(houseFrac);
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " AS house WHERE true" + (areaId > 0 ? " AND house.areaid=?" : "") + (quarterId > 0 ? " AND house.quarterid=?" : "") + (streetId > 0 ? " AND house.street_id=?" : "") + (house > -1 ? " AND house.house=?" : "") + (!frac.isEmpty() ? " AND house.frac LIKE ?" : "") + " ORDER BY house.house, house.frac" + this.sqlLimit(page);
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                if (areaId > 0) {
                    ps.setInt(index++, areaId);
                }
                if (quarterId > 0) {
                    ps.setInt(index++, quarterId);
                }
                if (streetId > 0) {
                    ps.setInt(index++, streetId);
                }
                if (house > -1) {
                    ps.setInt(index++, house);
                }
                if (!frac.isEmpty()) {
                    ps.setString(index++, frac);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        list.add(this.getFromRS(rs));
                    }
                }
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public House get(String title) throws BGException {
        return (House)super.get("house=?", title);
    }

    public List<House> list() throws BGException {
        return super.list(null, "house", new Object[0]);
    }

    public void update(House k) throws BGException, SQLException {
        super.update((Object)k);
    }

    public int streetHouseCount(int streetId) throws BGException {
        return this.getEntityCount(streetId, "street_id");
    }

    public int areaHouseCount(int areaId) throws BGException {
        return this.getEntityCount(areaId, "areaid");
    }

    public int quarterHouseCount(int quarterId) throws BGException {
        return this.getEntityCount(quarterId, "quarterid");
    }
}

