/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractCredentials;

public class MegogoContractCredentialsDao
extends AbstractDao<MegogoContractCredentials> {
    public MegogoContractCredentialsDao(Connection con, int moduleId) {
        super(con, "megogo_contract_credentials", moduleId);
    }

    public MegogoContractCredentials getByContractId(int contractId) throws SQLException {
        return (MegogoContractCredentials)this.get("contractId=?", new Object[]{contractId});
    }

    public MegogoContractCredentials getByLogin(String login) throws SQLException {
        if (login == null) {
            throw new BGRuntimeException("Login \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        return (MegogoContractCredentials)this.get("login=?", new Object[]{login});
    }

    protected void updateImpl(MegogoContractCredentials contractLogin) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " ( contractId, uid, login, pwd ) VALUES ( ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE login=?, pwd=? ";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractLogin.getContractId());
            ps.setInt(index++, contractLogin.getUid());
            ps.setString(index++, contractLogin.getLogin());
            ps.setString(index++, contractLogin.getPwd());
            ps.setString(index++, contractLogin.getLogin());
            ps.setString(index++, contractLogin.getPwd());
            ps.executeUpdate();
        }
    }

    protected MegogoContractCredentials getFromRS(ResultSet rs) throws SQLException {
        MegogoContractCredentials contractLogin = new MegogoContractCredentials();
        contractLogin.setContractId(rs.getInt("contractId"));
        contractLogin.setLogin(rs.getString("login"));
        contractLogin.setPwd(rs.getString("pwd"));
        contractLogin.setLm((Date)rs.getTimestamp("lm"));
        contractLogin.setUid(rs.getInt("uid"));
        return contractLogin;
    }
}

