/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client;

import java.util.Date;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeValue;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseData;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;

public class WarehouseUtils {
    public static String getUserNameByUserId(ClientContext context, int userId) throws BGException {
        UserInfo userInfo = (UserInfo)context.getDirectory(UserInfo.class).get(userId);
        return userInfo == null ? "" : userInfo.getName();
    }

    public static String getFullAddressByHouseId(ClientContext context, int houseId) throws Exception {
        if (houseId <= 0) {
            return "";
        }
        HouseData house = ((AddressService)context.getWebService(AddressService.class, 0)).houseDataGet(houseId);
        return house.getCityTitle() + ", " + house.getStreetTitle() + ", " + house.getHouse();
    }

    public static String getFormattedDateStringOfDate(String value) {
        if (Utils.isBlankString((String)value)) {
            return "";
        }
        return TimeUtils.format((Date)new Date(Utils.parseLong((String)value)), (String)"dd.MM.yyyy");
    }

    public static String getFormattedDateStringOfDatetime(String value) {
        if (Utils.isBlankString((String)value)) {
            return "";
        }
        return TimeUtils.format((Date)new Date(Utils.parseLong((String)value)), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String getStockItemAttributeValue(ClientContext context, StockItemAttributeValue attributeValue) throws Exception {
        switch (attributeValue.getAttribute().getAttributeType()) {
            case USER: {
                return WarehouseUtils.getUserNameByUserId(context, Utils.parseInt((String)attributeValue.getValue(), (int)-1));
            }
            case DATE: {
                return WarehouseUtils.getFormattedDateStringOfDate(attributeValue.getValue());
            }
            case DATETIME: {
                return WarehouseUtils.getFormattedDateStringOfDatetime(attributeValue.getValue());
            }
            case ADDRESS: {
                return WarehouseUtils.getFullAddressByHouseId(context, Utils.parseInt((String)attributeValue.getValue(), (int)0));
            }
        }
        return attributeValue.getValue();
    }
}

