/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.recalculate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceTrafficRangeRecalculateManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.server.util.Setup;

public class RangeRecalculateFlushingManager {
    private final Setup setup;
    private final VoiceTariffContext tariffContext;
    private final int moduleId;
    private Map<Integer, Set<Integer>> affectedDaysForContracts;

    public RangeRecalculateFlushingManager(Setup setup, VoiceTariffContext tariffContext, int moduleId, Map<Integer, Set<Integer>> affectedDaysForContracts) {
        this.setup = setup;
        this.tariffContext = tariffContext;
        this.moduleId = moduleId;
        this.affectedDaysForContracts = affectedDaysForContracts;
    }

    public void flushMonthRange(Date month) throws SQLException, BGException {
        try (Connection con = this.setup.getDBConnectionFromPool();
             VoiceTrafficRangeRecalculateManager rangeManager = new VoiceTrafficRangeRecalculateManager(con, month, month, this.moduleId, this.tariffContext.rangedTrafficManager);){
            Map rangedTrafficMap = this.tariffContext.rangedTrafficManager.rangedTrafficMap();
            for (Map.Entry entry : rangedTrafficMap.entrySet()) {
                int contractId = (Integer)entry.getKey();
                rangeManager.setAffectedDaysForContract(this.affectedDaysForContracts.get(contractId));
                rangeManager.flushContract(contractId);
            }
        }
    }
}

