/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.bean.range.VoiceGeographicRangeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class VoiceDestinationDao
extends AbstractIdDao<VoiceDestination> {
    public static final String VOICE_DESTINATION_TABLE = "voice_destination";

    public VoiceDestinationDao(Connection con, int moduleId) {
        super(con, moduleId, VOICE_DESTINATION_TABLE);
    }

    protected VoiceDestination getFromRS(ResultSet rs) throws SQLException {
        VoiceDestination result = new VoiceDestination(rs.getInt("id"), rs.getString("title"));
        result.setOperatorId(rs.getInt("operatorId"));
        return result;
    }

    protected void updateImpl(VoiceDestination voiceDestination) throws SQLException {
        String querySet = "title=?, operatorId=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)voiceDestination, querySet);){
            int index = 1;
            ps.setString(index++, voiceDestination.getTitle());
            if (voiceDestination.getOperatorId() == 0) {
                ps.setNull(index++, 4);
            } else {
                ps.setInt(index++, voiceDestination.getOperatorId());
            }
            this.executeUpdate((Id)voiceDestination, index, ps);
        }
    }

    public Map<String, VoiceDestination> titleMap(int operatorId) throws SQLException {
        return this.list(operatorId, null, false, null).stream().collect(Collectors.toMap(IdTitle::getTitle, Function.identity()));
    }

    public Map<Integer, VoiceDestination> idMap(int operatorId) throws SQLException {
        return this.list(operatorId, null, false, null).stream().collect(Collectors.toMap(Id::getId, Function.identity()));
    }

    public void searchDestination(SearchResult<VoiceDestination> searchResult, int operatorId, String title, boolean addLinkCount) throws SQLException {
        searchResult.setList(this.list(operatorId, title, addLinkCount, searchResult.getPage()));
    }

    public List<IdTitle> list(List<Integer> destIds) throws SQLException {
        return destIds == null || destIds.isEmpty() ? Collections.emptyList() : this.list("id IN ( " + Utils.toString(destIds) + " )", "title", new Object[0]).stream().map(IdTitle::toIdTitle).toList();
    }

    public List<VoiceDestination> list(int operatorId, String title, boolean addLinkCount, Page page) throws SQLException {
        ArrayList<VoiceDestination> result = new ArrayList<VoiceDestination>();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE ";
        Object whereClause = "1=1 ";
        whereClause = (String)whereClause + " AND operatorId" + (String)(operatorId > 0 ? "=" + operatorId : " IS NULL");
        if (Utils.notBlankString((String)title)) {
            whereClause = (String)whereClause + " AND title LIKE ?";
        }
        query = query + (String)whereClause;
        query = query + " ORDER BY title";
        query = query + this.sqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            HashSet<Integer> destionationIds = new HashSet<Integer>();
            int index = 1;
            if (Utils.notBlankString((String)title)) {
                ps.setString(index++, "%" + title + "%");
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    VoiceDestination voiceDestination = this.getFromRS(rs);
                    result.add(voiceDestination);
                    destionationIds.add(voiceDestination.getId());
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
            if (addLinkCount) {
                VoiceGeographicRangeDao rangeDao = new VoiceGeographicRangeDao(this.con, this.moduleId);
                VoiceGeographicCodeDao codeDao = new VoiceGeographicCodeDao(this.con, this.moduleId);
                Map<Integer, Integer> codeLinks = codeDao.getDestinationLinkCountMap(destionationIds);
                result.forEach(a -> a.setCodeLinkCount(codeLinks.getOrDefault(a.getId(), 0).intValue()));
                Map<Integer, Integer> rangeLinks = rangeDao.getDestinationLinkCountMap(destionationIds);
                result.forEach(a -> a.setRangeLinkCount(rangeLinks.getOrDefault(a.getId(), 0).intValue()));
            }
        }
        return result;
    }

    public int delete(List<Integer> idList) throws SQLException {
        int result = 0;
        String query = "DELETE FROM " + this.tableName + " WHERE id IN (" + Utils.toString(idList) + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            result = ps.executeUpdate();
        }
        return result;
    }

    public VoiceDestination get(String title) throws SQLException {
        VoiceDestination result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE title=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, title);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getFromRS(rs);
                }
            }
        }
        return result;
    }
}

