#!/bin/bash

if [[ ! -f "/etc/systemd/system/activemq.service" ]]; then

cat << EOF > /etc/systemd/system/activemq.service
[Unit]
Description=Apache ActiveMQ
After=network-online.target

[Service]
Type=forking
WorkingDirectory=/opt/activemq/bin
ExecStart=/opt/activemq/bin/activemq start
ExecStop=/opt/activemq/bin/activemq stop
Restart=on-abort
User=root
Group=root

[Install]
WantedBy=multi-user.target
EOF

fi

systemctl daemon-reload
systemctl enable --now activemq.service


chmod 0755 /opt/bgbilling/BGBillingServer/bin/*.sh
chmod 0755 /opt/bgbilling/BGBillingServer/script/*.sh
cd /opt/bgbilling/BGBillingServer/script
/opt/bgbilling/BGBillingServer/script/service_install.sh


chmod 0755 /opt/bgbilling/BGScheduler/bin/*.sh
chmod 0755 /opt/bgbilling/BGScheduler/script/*.sh
cd /opt/bgbilling/BGScheduler/script
/opt/bgbilling/BGScheduler/script/service_install.sh


mysql -uroot < /opt/bgbilling/dump.sql