/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentSearchInfo;
import ru.bitel.bgbilling.plugins.edo.common.bean.EdoDocumentType;
import ru.bitel.bgbilling.plugins.edo.common.bean.Signatory;
import ru.bitel.bgbilling.plugins.edo.server.bean.ContractConfigManager;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoDocumentTypeDao;
import ru.bitel.bgbilling.plugins.edo.server.bean.SignatoryDao;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ScriptUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class EdoManager {
    private Connection con;
    private int userId;
    private Setup setup = Setup.getSetup();
    private ScriptUtils scriptUtils;
    private BGPluginServer plugin;
    private EdoDocumentTypeDao edoDocumentTypeDao;
    private SignatoryDao signatoryDao;
    private ContractConfigManager contractConfigManager;

    public EdoManager(Connection con, int userId) {
        this.con = con;
        this.userId = userId;
        this.scriptUtils = new ScriptUtils((DefaultServerSetup)this.setup, con);
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.edo");
        this.edoDocumentTypeDao = new EdoDocumentTypeDao(con);
        this.signatoryDao = new SignatoryDao(con);
        this.contractConfigManager = new ContractConfigManager(con);
    }

    public ContragentSearchInfo getContragentSearchInfoForContract(int contractId) throws BGException {
        try {
            ContragentSearchInfo csi = new ContragentSearchInfo();
            csi.setInn(this.value(contractId, "search.inn"));
            csi.setKpp(this.value(contractId, "search.kpp"));
            csi.setF(this.value(contractId, "search.f"));
            csi.setI(this.value(contractId, "search.i"));
            csi.setO(this.value(contractId, "search.o"));
            csi.setSnils(this.value(contractId, "search.snils"));
            return csi;
        }
        catch (Exception e) {
            throw new BGException("error get contragent search info", (Throwable)e);
        }
    }

    private String value(int contractId, String nameValue) throws Exception {
        Preferences pluginSetup = this.plugin.getSetup();
        String value = pluginSetup.get(nameValue);
        if (value == null) {
            return null;
        }
        if (value.startsWith("pid:")) {
            int pid = -1;
            try {
                pid = Integer.valueOf(value.substring(4));
            }
            catch (Exception e) {
                throw new BGException("\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 " + nameValue + "=" + value);
            }
            value = this.scriptUtils.getContractParameter(contractId, pid);
        }
        return value != null ? value.strip() : null;
    }

    public List<KeyValue> formatsList() throws Exception {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        Map<Integer, Signatory> signatoryMap = this.signatoryDao.getMapAll();
        for (EdoDocumentType edoDocumentType : this.edoDocumentTypeDao.getListAll()) {
            ArrayList<Integer> signatoryIds = null;
            signatoryIds = Utils.notEmptyCollection((Collection)edoDocumentType.getSignatoryIds()) ? edoDocumentType.getSignatoryIds() : new ArrayList<Integer>(signatoryMap.keySet());
            for (Integer signatoryId : signatoryIds) {
                Signatory signatory = signatoryMap.get(signatoryId);
                if (signatory == null) continue;
                String formatId = String.format("%d_%d", edoDocumentType.getId(), signatoryId);
                String formatTitle = String.format("%s ~ %s", edoDocumentType.getTitle(), signatory.getTitle());
                list.add(new KeyValue(formatId, formatTitle));
            }
        }
        return list;
    }

    public ParameterMap getDocumentSetup(int edoDocumentTypeId, int signatoryId, int contractId) throws SQLException, BGException {
        EdoDocumentType documentType = (EdoDocumentType)this.edoDocumentTypeDao.get(edoDocumentTypeId);
        Preferences documentSetup = new Preferences(documentType.getConfig(), "\n");
        Signatory signatory = (Signatory)this.signatoryDao.get(signatoryId);
        Preferences signatorySetup = new Preferences(signatory.getConfig(), "\n");
        documentSetup = documentSetup.inherit((ParameterMap)signatorySetup);
        String contractConfig = this.contractConfigManager.getConfig(contractId);
        if (Utils.notBlankString((String)contractConfig)) {
            Preferences contractSetup = new Preferences(contractConfig, "\n");
            documentSetup = documentSetup.inherit((ParameterMap)contractSetup);
        }
        return documentSetup;
    }
}

