/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.service;

import jakarta.jws.WebService;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentSearchInfo;
import ru.bitel.bgbilling.plugins.edo.common.service.EDOService;
import ru.bitel.bgbilling.plugins.edo.server.bean.ContractConfigManager;
import ru.bitel.bgbilling.plugins.edo.server.bean.EdoManager;
import ru.bitel.bgbilling.plugins.edo.server.provider.sbis.SbisAPI;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.edo.common.service.EDOService")
public class EDOServiceImpl
extends AbstractService
implements EDOService {
    public List<KeyValue> formatsList() throws Exception {
        return new EdoManager(this.getConnection(), this.userId).formatsList();
    }

    public SearchResult<String> sbisChangeList(int contractId, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.getList().addAll(new SbisAPI(this.userId).doChangeList());
        return searchResult;
    }

    public ContragentInfos sbisSearchContragent(ContragentSearchInfo searchInfo) throws BGException {
        ContragentInfos contragentInfos = new SbisAPI(this.userId).contragentInfo(searchInfo);
        return contragentInfos;
    }

    public ContragentSearchInfo fillContragentSearchInfo(int contractId) throws BGException {
        EdoManager em = new EdoManager(this.getConnection(), this.userId);
        return em.getContragentSearchInfoForContract(contractId);
    }

    public String getContractEdoConfig(int contractId) throws BGException, BGMessageException {
        return new ContractConfigManager(this.getConnection()).getConfig(contractId);
    }

    public void saveContractEdoConfig(int contractId, String config) throws BGException, BGMessageException {
        new ContractConfigManager(this.getConnection()).saveConfig(contractId, config);
    }
}

