/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.worker.BatchWorker;

public class SessionCleanWorker
extends BatchWorker<SessionCleanTask, ServerContext> {
    private final int moduleId;
    private final BlockingQueue<SessionCleanTask> queue;
    private final long defaultTimeout;
    private final Random random = new Random();
    private Connection con;
    private PreparedStatement deleteAccountPS;
    private PreparedStatement selectDetailPS;
    private PreparedStatement deleteDetailPS;

    public SessionCleanWorker(Setup setup, int moduleId, int capacity, long defaultTimeout) {
        this.errorPause = 250 + 250 * this.random.nextInt(2);
        this.moduleId = moduleId;
        this.context = new ServerContext(setup, moduleId, 0);
        this.queue = new LinkedBlockingQueue<SessionCleanTask>(capacity);
        this.defaultTimeout = defaultTimeout;
        new Thread((Runnable)((Object)this), "sessn-cln-worker").start();
    }

    protected SessionCleanTask takeImpl() throws Exception {
        return this.queue.take();
    }

    protected SessionCleanTask pollImpl(long timeout) throws Exception {
        return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean offer(SessionCleanTask task) throws InterruptedException {
        return this.queue.offer(task, this.defaultTimeout, TimeUnit.MILLISECONDS);
    }

    public boolean offer(SessionCleanTask task, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offer(task, timeout, unit);
    }

    protected boolean runWorker() throws BGException {
        try {
            this.errorPause = 250 + 250 * this.random.nextInt(2);
            this.con = ((ServerContext)this.context).getConnection();
            this.connect();
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.disconnect();
            ((ServerContext)this.context).recycle();
            this.con = null;
        }
    }

    private void connect() throws BGException {
        try {
            this.con.setAutoCommit(true);
            this.deleteAccountPS = this.con.prepareStatement("DELETE FROM inet_session_account_" + this.moduleId + " WHERE contractId=? AND sessionId=?");
            this.selectDetailPS = this.con.prepareStatement("SELECT DISTINCT day, hour FROM inet_session_detail_" + this.moduleId + " WHERE sessionId=?");
            this.deleteDetailPS = this.con.prepareStatement("DELETE FROM inet_session_detail_" + this.moduleId + " WHERE sessionId=? AND day=? AND hour=?");
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void disconnect() throws BGException {
        try {
            if (this.deleteAccountPS != null) {
                this.deleteAccountPS.close();
                this.deleteAccountPS = null;
            }
            if (this.selectDetailPS != null) {
                this.selectDetailPS.close();
                this.selectDetailPS = null;
            }
            if (this.deleteDetailPS != null) {
                this.deleteDetailPS.close();
                this.deleteDetailPS = null;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Object doTask(SessionCleanTask task) throws BGException {
        try {
            this.deleteAccountPS.setInt(1, task.contractId);
            this.deleteAccountPS.setLong(2, task.sessionId);
            this.deleteAccountPS.executeUpdate();
            if (!this.con.getAutoCommit()) {
                this.con.commit();
            }
            this.selectDetailPS.setLong(1, task.sessionId);
            this.deleteDetailPS.setLong(1, task.sessionId);
            try (ResultSet rs = this.selectDetailPS.executeQuery();){
                while (rs.next()) {
                    this.deleteDetailPS.setInt(2, rs.getInt(1));
                    this.deleteDetailPS.setInt(3, rs.getInt(2));
                    this.deleteDetailPS.executeUpdate();
                    if (this.con.getAutoCommit()) continue;
                    this.con.commit();
                }
            }
        }
        catch (SQLException e) {
            this.queue.offer(task);
            throw new BGException((Throwable)e);
        }
        Thread.yield();
        return null;
    }

    public static class SessionCleanTask {
        final int contractId;
        final long sessionId;

        public SessionCleanTask(int contractId, long sessionId) {
            this.contractId = contractId;
            this.sessionId = sessionId;
        }
    }
}

