/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscriptionStatusPeriod;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Period;

public class MegogoContractSubscriptionStatusPeriodDao
extends AbstractIdDao<MegogoContractSubscriptionStatusPeriod> {
    public MegogoContractSubscriptionStatusPeriodDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_subscription_status_period");
    }

    public List<MegogoContractSubscriptionStatusPeriod> getList(int idSub, int status, boolean dateToIsNull, Date date) throws SQLException {
        return this.getList(idSub, status, dateToIsNull, new Period(date, date));
    }

    public List<MegogoContractSubscriptionStatusPeriod> getList(int idSub, int status, boolean dateToIsNull, Period period) throws SQLException {
        String query = "SELECT * FROM " + this.tableName + " WHERE idSub=" + idSub;
        if (status > 0) {
            query = query + " AND status=" + status;
        }
        if (dateToIsNull) {
            query = query + " AND dateTo IS NULL";
        }
        if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
            query = query + " AND DATE(dateFrom)<=? AND ( dateTo IS NULL OR DATE(dateTo)>=? )";
        }
        query = query + " ORDER BY id DESC";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            List list;
            block16: {
                if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
                    ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                    ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getListFromRS(rs);
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    protected MegogoContractSubscriptionStatusPeriod getFromRS(ResultSet rs) throws SQLException {
        MegogoContractSubscriptionStatusPeriod statusPeriod = new MegogoContractSubscriptionStatusPeriod();
        statusPeriod.setId(rs.getInt("id"));
        statusPeriod.setIdSub(rs.getInt("idSub"));
        statusPeriod.setStatus(rs.getInt("status"));
        statusPeriod.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        statusPeriod.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        return statusPeriod;
    }

    protected void updateImpl(MegogoContractSubscriptionStatusPeriod statusPeriod) throws SQLException {
        String querySet = "idSub=?, status=?, dateFrom=?, dateTo=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)statusPeriod, querySet);){
            int index = 1;
            ps.setInt(index++, statusPeriod.getIdSub());
            ps.setInt(index++, statusPeriod.getStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)statusPeriod.getDateFrom()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)statusPeriod.getDateTo()));
            this.executeUpdate((Id)statusPeriod, index, ps);
        }
    }
}

