/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.notification.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.notification.common.bean.NotificationData;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.PeriodWithTime;

public class NotificationDao
extends AbstractIdDao<NotificationData> {
    public NotificationDao(Connection con) {
        super(con, 0, "notification_data");
    }

    public List<NotificationData> list(int contractId) throws SQLException {
        return this.list("contract_id=?", "", new Object[]{contractId});
    }

    protected NotificationData getFromRS(ResultSet rs) throws SQLException {
        return NotificationData.builder().setId(rs.getInt("id")).setContractId(rs.getInt("contract_id")).setTitle(rs.getString("subject")).setPeriod(new PeriodWithTime((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to"))).setData(rs.getString("data")).setHandlerClassName(rs.getString("handler_class_name")).build();
    }

    protected void updateImpl(NotificationData notificationData) throws SQLException {
        String querySet = "contract_id=?, subject=?, date_from=?, date_to=?, data=?, handler_class_name=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)notificationData, querySet);){
            PeriodWithTime period = notificationData.getPeriod();
            if (period == null) {
                period = new PeriodWithTime();
            }
            int index = 1;
            ps.setInt(index++, notificationData.getContractId());
            ps.setString(index++, notificationData.getTitle());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)period.getLocalDateTimeFrom()));
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)period.getLocalDateTimeTo()));
            ps.setString(index++, notificationData.getData());
            ps.setString(index++, notificationData.getHandlerClassName());
            this.executeUpdate((Id)notificationData, index, ps);
        }
    }
}

