/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.event.ProductModifiedEvent;
import ru.bitel.oss.systems.inventory.product.common.event.ProductPeriodModifiedEvent;

public class ProductPeriodRuntimeQueue
extends WorkerTask<ServerContext>
implements EventListener<Event>,
Runnable {
    private static final Logger logger = LogManager.getLogger();
    private static int LOAD_DAYS = 3;
    private final Setup setup;
    private final int moduleId;
    private final ConcurrentMap<Key, Entry> map;
    private final DelayQueue<Entry> queue;

    public ProductPeriodRuntimeQueue(Setup setup, int moduleId, ScheduledExecutorService scheduledExecutorService) throws BGException {
        this.setup = setup;
        this.moduleId = moduleId;
        this.map = new ConcurrentHashMap<Key, Entry>();
        this.queue = new DelayQueue();
        EventProcessor.getInstance().addListener((EventListener)this, ProductPeriodModifiedEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)this, ProductModifiedEvent.class, moduleId, null);
        scheduledExecutorService.scheduleWithFixedDelay(this, 0L, 20L, TimeUnit.MINUTES);
    }

    public void notify(Event ev, EventListenerContext ctx) throws BGException {
        if (ev instanceof ProductPeriodModifiedEvent) {
            ProductPeriodModifiedEvent e = (ProductPeriodModifiedEvent)ev;
            logger.debug("Catch period update");
            if (e.getNewProductPeriodTimeTo() != null) {
                Directory productSpecDirectory = ctx.getDirectory(ProductSpec.class, 0);
                ProductSpec productSpec = (ProductSpec)productSpecDirectory.get(e.getProductSpecId());
                if (productSpec == null || productSpec.getModuleId() != this.moduleId) {
                    return;
                }
                if (productSpec.isNotRealtime()) {
                    logger.debug("notRealtime period update - skip");
                    return;
                }
                long periodTimeTo = e.getNewProductPeriodTimeTo().getTime();
                if (Instant.ofEpochMilli(periodTimeTo).atZone(ZoneId.systemDefault()).toLocalDate().isAfter(LocalDate.now().plusDays(LOAD_DAYS))) {
                    logger.debug("skip future period end");
                    return;
                }
                logger.debug("period update");
                this.put(2, e.getProductPeriodId(), e.getProductId(), e.getAccountId(), e.getContractId(), periodTimeTo, e.getVersion());
            }
        } else if (ev instanceof ProductModifiedEvent) {
            ProductModifiedEvent e = (ProductModifiedEvent)ev;
            logger.debug("Catch product update");
            Product product = e.getNewProduct();
            if (logger.isDebugEnabled()) {
                logger.debug("newProduct = {}", (Object)(product != null ? product.toString() : "null"));
            }
            if (product != null && product.getTimeTo() != null) {
                ProductSpec productSpec = (ProductSpec)ctx.getDirectory(ProductSpec.class, 0).get(product.getProductSpecId());
                if (logger.isDebugEnabled()) {
                    logger.debug("productSpec = {}", (Object)(productSpec != null ? productSpec.toString() : "null"));
                }
                if (productSpec == null || productSpec.getModuleId() != this.moduleId) {
                    return;
                }
                logger.debug("product update");
                this.put(2, 0, product.getId(), product.getAccountId(), e.getContractId(), product.getTimeTo().getTime(), 0);
            }
        }
    }

    protected void runImpl() throws Exception {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.load(con);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void load(Connection con) throws SQLException, BGException {
        logger.debug("Reload queue from DB");
        Directory productSpecDirectory = ((ServerContext)this.context).getDirectory(ProductSpec.class, 0);
        PreparedStatement ps = con.prepareStatement("SELECT product.id, product.contractId, product.accountId, product.productSpecId, product.timeFrom, product.timeTo, period.id, period.timeFrom, period.timeTo, period.flags, period.version FROM inv_product as product LEFT JOIN inv_product_period as period ON product.id=period.productId WHERE (product.timeTo IS NULL OR product.timeTo>?) AND (period.timeTo>?) AND (period.timeTo<?) AND (period.flags&?)=0");
        ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)Date.from(ZonedDateTime.now().minusMonths(4L).toInstant())));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)Date.from(ZonedDateTime.now().minusMonths(4L).toInstant())));
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)Date.from(ZonedDateTime.now().plusDays(LOAD_DAYS).toInstant())));
        ps.setInt(4, 7);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int productId = rs.getInt(1);
            int contractId = rs.getInt(2);
            int accountId = rs.getInt(3);
            int productSpecId = rs.getInt(4);
            ProductSpec productSpec = (ProductSpec)productSpecDirectory.get(productSpecId);
            if (productSpec == null || productSpec.getModuleId() != this.moduleId || productSpec.isNotRealtime()) continue;
            Timestamp productTimeTo = rs.getTimestamp(6);
            int periodId = rs.getInt(7);
            Timestamp periodTimeFrom = rs.getTimestamp(8);
            Timestamp periodTimeTo = rs.getTimestamp(9);
            int version = rs.getInt(11);
            if (periodTimeFrom == null) {
                logger.error("Skipping period " + periodId + " with timeFrom==null");
                continue;
            }
            if (periodTimeTo == null) {
                logger.error("Skipping period " + periodId + " with timeTo==null");
                continue;
            }
            if (periodId <= 0) {
                this.put(1, periodId, productId, accountId, contractId, ((Date)periodTimeFrom).getTime(), version);
            } else {
                this.put(2, periodId, productId, accountId, contractId, ((Date)periodTimeTo).getTime(), version);
            }
            if (productTimeTo == null) continue;
            this.put(2, 0, productId, accountId, contractId, ((Date)productTimeTo).getTime(), 0);
        }
    }

    boolean put(int type, int periodId, int productId, int accountId, int contractId, long time, int version) {
        Key key = new Key(productId, periodId, type);
        Entry entry = (Entry)this.map.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Put: key={}; entry={}", (Object)key, (Object)entry);
        }
        if (entry != null && entry.key.periodId == periodId && entry.key.productId == productId && entry.version >= version && periodId != 0) {
            return false;
        }
        if (entry != null && entry.time > System.currentTimeMillis() + TimeUnit.DAYS.toMillis(3L)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Put: queue.remove( {} );", (Object)entry);
            }
            this.queue.remove(entry);
        }
        entry = new Entry(key, productId, accountId, contractId, time, version);
        this.map.put(key, entry);
        this.queue.add(entry);
        return true;
    }

    public Entry take() throws InterruptedException {
        Entry result = (Entry)this.queue.take();
        this.map.remove(result.key, result);
        return result;
    }

    public Entry poll(long timeout, TimeUnit unit) throws InterruptedException {
        Entry result = (Entry)this.queue.poll(timeout, unit);
        if (result != null) {
            this.map.remove(result.key, result);
        }
        return result;
    }

    static class Key {
        public static final int START = 1;
        public static final int STOP = 2;
        final int productId;
        final int periodId;
        final int type;

        public Key(int productId, int periodId, int type) {
            this.productId = productId;
            this.periodId = periodId;
            this.type = type;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.productId) + this.periodId) + this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            return this.periodId == other.periodId && this.productId == other.productId && this.type == other.type;
        }
    }

    static class Entry
    implements Delayed {
        final Key key;
        final int contractId;
        final int accountId;
        final int productId;
        final long time;
        final int version;

        public Entry(Key key, int productId, int accountId, int contractId, long time, int version) {
            this.key = key;
            this.productId = productId;
            this.accountId = accountId;
            this.contractId = contractId;
            this.time = key.type == 1 ? time / 1000L * 1000L : time / 1000L * 1000L + 999L;
            this.version = version;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            assert (this.time != 0L);
            return unit.convert(this.time - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            Entry x = (Entry)other;
            long diff = this.time - x.time;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.key.productId + ":" + this.key.periodId + " cid:" + this.contractId + ", aid:" + this.accountId + ", type:" + this.key.type + " " + String.valueOf(new Date(this.time));
        }
    }
}

