/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.server.dao;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusCharge;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusContractProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusDetailCharge;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPayment;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPaymentType;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgramSpecification;
import ru.bitel.bgbilling.plugins.bonus.server.bean.OperationBonusProgram;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class BonusDao
extends BGLogger {
    private static final String TABLE_BONUS_PAYMENT_TYPE = "bonus_payment_type";
    private static final String TABLE_BONUS_CONTRACT_PAYMENT = "bonus_contract_payment";
    private static final String TABLE_BONUS_CONTRACT_PROGRAM = "bonus_contract_program";
    private static final String TABLE_BONUS_PROGRAMS = "bonus_programs";
    private static final String TABLE_BONUS_PROGRAM_DATA_CONTRACT = "bonus_program_data_contract";
    protected Connection con = null;
    public static int pluginTurnOn = 1;
    public static final boolean flagBalanceCanBeNegative;

    public BonusDao(Connection con) {
        this.con = con;
    }

    public List<BonusPaymentType> getPaymentTypeList(boolean usedOnly) throws Exception {
        ArrayList<BonusPaymentType> list = new ArrayList<BonusPaymentType>();
        StringBuilder query = new StringBuilder();
        if (usedOnly) {
            query.append("SELECT * FROM bonus_payment_type b WHERE b.used=1");
        } else {
            query.append("SELECT * FROM bonus_payment_type");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                if (rs.getInt("used") != 0 && rs.getInt("used") != 1) continue;
                list.add(new BonusPaymentType(rs.getInt("id"), rs.getString("name"), rs.getInt("used") == 1));
            }
        }
        return list;
    }

    public List<BonusCharge> getChargesLinkedPayments(int cid, List<BonusPayment> paymentList, Date date) throws Exception {
        if (paymentList.size() < 1) {
            return null;
        }
        ArrayList<BonusCharge> list = new ArrayList<BonusCharge>();
        StringBuilder items = new StringBuilder();
        for (int i = 0; i < paymentList.size(); ++i) {
            items.append(paymentList.get(i).getId() + ",");
        }
        items.replace(items.length() - 1, items.length(), "");
        StringBuilder query = new StringBuilder();
        query.append("SELECT bc.id, bc.date, bc.sum, bc.contractChargeId, ch.pt FROM ( SELECT DISTINCT chargeId FROM bonus_details_charge c WHERE  paymentId IN (" + String.valueOf(items) + ") ) d LEFT JOIN bonus_contract_charge bc ON d.chargeId=bc.id LEFT JOIN contract_charge ch ON bc.contractChargeId=ch.id WHERE bc.cid=? AND DATE(bc.date)<=?");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(new BonusCharge(rs.getInt("id"), (Date)rs.getTimestamp("date"), rs.getInt("pt"), rs.getBigDecimal("sum"), rs.getInt("contractChargeId")));
                }
            }
        }
        return list;
    }

    public void updatePaymentType(BonusPaymentType paymentType) throws Exception {
        if (paymentType.getId() == 0) {
            String query = "INSERT INTO bonus_payment_type (name, used ) VALUES ('" + paymentType.getTitle() + "', " + Utils.booleanToStringInt((boolean)paymentType.isUsed()) + ")";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.execute();
            }
        }
        if (paymentType.getId() > 0) {
            String query = "UPDATE bonus_payment_type SET name='" + paymentType.getTitle() + "', used=" + Utils.booleanToStringInt((boolean)paymentType.isUsed()) + " WHERE id=" + paymentType.getId();
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.executeUpdate();
            }
        }
    }

    public void deletePaymentType(int paymentId) throws BGException {
        String query = "DELETE FROM bonus_payment_type WHERE id=" + paymentId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean isUsePaymentType(int paymentId) throws BGException {
        boolean result = true;
        String query = "SELECT * FROM bonus_contract_payment WHERE typeId=" + paymentId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            result = false;
            if (rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public boolean isUseChargeType(int chargeId) throws BGException {
        boolean result = true;
        String query = "SELECT * FROM bonus_contract_charge WHERE typeId=" + chargeId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            result = false;
            if (rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<BonusPayment> getPaymentList(int contractId, Date dateFrom, Date dateTo) throws BGException {
        ArrayList<BonusPayment> list = new ArrayList<BonusPayment>();
        StringBuilder query = new StringBuilder("SELECT c.*, t.name FROM (SELECT * FROM bonus_contract_payment c WHERE c.cid=" + contractId);
        if (dateFrom != null && dateTo != null) {
            query.append(" AND DATE(c.date) >= ? AND DATE(c.date) <= ?");
        }
        query.append(" ) c LEFT JOIN bonus_payment_type t ON t.id=c.typeId");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (dateFrom != null && dateTo != null) {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)dateFrom));
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)dateTo));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getBonusPaymentFromRSWhithName(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public List<BonusPayment> getPaymentsAll(int cid) throws BGException {
        return this.getPaymentList(cid, null, null);
    }

    public List<BonusPayment> getPaymentsActiveAndPositive(int cid, Date date, HashMap<Integer, BigDecimal> residueSumMap) throws BGException {
        ArrayList<BonusPayment> list = new ArrayList<BonusPayment>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM bonus_contract_payment p LEFT JOIN  (SELECT paymentId,SUM(d.sum) AS spendSum FROM bonus_details_charge d GROUP BY d.paymentId) AS res ON p.id=res.paymentId WHERE p.cid=" + cid + " AND ? >= p.dateFrom AND ? <= p.dateTo AND ( spendSum is null OR spendSum<sum ) ORDER BY dateTo");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getBonusPaymentFromRS(rs));
                if (residueSumMap == null) continue;
                if (rs.getBigDecimal("spendSum") != null) {
                    residueSumMap.put(rs.getInt("id"), rs.getBigDecimal("sum").subtract(rs.getBigDecimal("spendSum")));
                    continue;
                }
                residueSumMap.put(rs.getInt("id"), rs.getBigDecimal("sum"));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public List<BonusPayment> getPaymentsActiveToDate(int cid, Date date, HashMap<Integer, BigDecimal> residueSumMap) throws BGException {
        ArrayList<BonusPayment> list = new ArrayList<BonusPayment>();
        StringBuilder query = new StringBuilder();
        if (residueSumMap != null) {
            query.append("SELECT p.*, p.sum-IFNULL(SUM(d.sum),0) as residueSum ");
            query.append("FROM (SELECT * FROM bonus_contract_payment p WHERE p.cid=? AND ? >= p.dateFrom AND ? <= p.dateTo) p ");
            query.append("LEFT JOIN (SELECT d.chargeId,d.paymentId,d.sum,c.date FROM bonus_details_charge d ");
            query.append("LEFT JOIN bonus_contract_charge c ON d.chargeId=c.id WHERE DATE(date)<=?) d ON d.paymentId=p.id GROUP BY p.id");
        } else {
            query.append("SELECT c.* ,t.name FROM (SELECT * FROM bonus_contract_payment p WHERE p.cid=? AND ? >= p.dateFrom AND ? <= p.dateTo)");
            query.append("c LEFT JOIN bonus_payment_type t ON t.id=c.typeId");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            if (residueSumMap != null) {
                ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BonusPayment payment = this.getBonusPaymentFromRS(rs);
                list.add(payment);
                if (residueSumMap == null) continue;
                residueSumMap.put(payment.getId(), rs.getBigDecimal("residueSum"));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public List<BonusPayment> getPaymentsToActiveInFuture(int contractId, Date date) throws BGException {
        ArrayList<BonusPayment> list = new ArrayList<BonusPayment>();
        StringBuilder query = new StringBuilder("SELECT c.* ,t.name FROM (SELECT * FROM bonus_contract_payment p ");
        query.append("WHERE p.cid=? AND p.dateFrom>? AND p.dateTo>? ) c LEFT JOIN bonus_payment_type t ON t.id=c.typeId");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    list.add(this.getBonusPaymentFromRSWhithName(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public BonusCharge getCharge(int contractChargeId) throws BGException {
        BonusCharge charge = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT bc.id, bc.date, bc.sum, bc.contractChargeId, ch.pt FROM bonus_contract_charge bc LEFT JOIN contract_charge ch ON bc.contractChargeId=ch.id WHERE bc.contractChargeId=" + contractChargeId);){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                charge = this.getBonusChargeFromRS(rs);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return charge;
    }

    public List<BonusCharge> getChargeList(int contractId, Date dateFrom, Date dateTo) throws BGException {
        ArrayList<BonusCharge> list = new ArrayList<BonusCharge>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT bc.id, bc.date, bc.sum, bc.contractChargeId, ch.pt FROM bonus_contract_charge bc LEFT JOIN contract_charge ch ON bc.contractChargeId=ch.id WHERE bc.cid=" + contractId);
        if (dateFrom != null && dateTo != null) {
            query.append(" AND DATE(bc.date) BETWEEN ? AND ? ");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (dateFrom != null && dateTo != null) {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)dateFrom));
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)dateTo));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getBonusChargeFromRS(rs));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public List<BonusCharge> getChargesAll(int contractId) throws BGException {
        return this.getChargeList(contractId, null, null);
    }

    public void updatePayment(int userId, int cid, BonusPayment payment) throws BGException {
        block17: {
            if (payment.getId() == 0) {
                try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO bonus_contract_payment VALUES (?,?,?,?,?,?,?,?,?)", 1);){
                    ps.setInt(1, payment.getId());
                    ps.setInt(2, cid);
                    ps.setInt(3, userId);
                    ps.setInt(4, payment.getTypeId());
                    ps.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)payment.getDate()));
                    ps.setBigDecimal(6, payment.getSum());
                    ps.setDate(7, TimeUtils.convertDateToSqlDate((Date)payment.getDateFrom()));
                    ps.setDate(8, TimeUtils.convertDateToSqlDate((Date)payment.getDateTo()));
                    ps.setString(9, payment.getComment());
                    ps.executeUpdate();
                    payment.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                    break block17;
                }
                catch (SQLException e) {
                    throw new BGException((Throwable)e);
                }
            }
            try (PreparedStatement ps = this.con.prepareStatement("UPDATE bonus_contract_payment SET dateTo=?, comment=? WHERE id=?", 1);){
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)payment.getDateTo()));
                ps.setString(2, payment.getComment());
                ps.setInt(3, payment.getId());
                ps.executeUpdate();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void addCharge(int userId, int cid, BonusCharge charge) throws BGException {
        if (charge.getContractChargeId() > 0) {
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO bonus_contract_charge(cid,uid,sum,date,contractChargeId) VALUES(?,?,?,?,?)");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);){
                ps.setInt(1, cid);
                ps.setInt(2, userId);
                ps.setBigDecimal(3, charge.getSum());
                ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)charge.getDate()));
                ps.setInt(5, charge.getContractChargeId());
                ps.executeUpdate();
                charge.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void deletePayment(int paymentId) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM bonus_contract_payment WHERE id=" + paymentId);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteCharge(int chargeId) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM bonus_contract_charge WHERE id=" + chargeId);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteChargeAccordingToContractChargeId(int contractChargeId) throws BGException {
        try {
            String query = "SELECT id FROM bonus_details_charge WHERE chargeId=( SELECT id FROM bonus_contract_charge WHERE contractChargeId=" + contractChargeId + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.deleteDeatails(rs.getInt("id"));
            }
            ps.close();
            ps = this.con.prepareStatement("DELETE FROM bonus_contract_charge WHERE contractChargeId=" + contractChargeId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<BonusPayment> getPaymentDetailsList(int chargeId) throws BGException {
        ArrayList<BonusPayment> list = new ArrayList<BonusPayment>();
        StringBuilder query = new StringBuilder("SELECT c.*, t.name FROM (SELECT p.id, p.cid, p.uid, p.typeId, p.date, p.dateFrom, p.dateTo, p.comment, b.sum FROM bonus_details_charge b ");
        query.append("LEFT JOIN bonus_contract_payment p ON p.id=b.paymentId WHERE b.chargeId=" + chargeId + " GROUP BY p.id ) c LEFT JOIN bonus_payment_type t ON t.id=c.typeId");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getBonusPaymentFromRSWhithName(rs));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    @Deprecated
    public List<BonusCharge> getChargeDetailsList(int paymentId) throws BGException {
        ArrayList<BonusCharge> list = new ArrayList<BonusCharge>();
        String query = "SELECT c.id,c.contractChargeId,c.date,b.sum,ch.pt FROM bonus_details_charge b LEFT JOIN  bonus_contract_charge c ON c.id=b.chargeId LEFT JOIN contract_charge ch ON ch.id=c.contractChargeId WHERE b.paymentId= " + paymentId + " GROUP BY c.id";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                list.add(this.getBonusChargeFromRS(rs));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public List<BonusDetailCharge> getDetailsChargeList(int paymentId) throws BGException {
        ArrayList<BonusDetailCharge> list = new ArrayList<BonusDetailCharge>();
        String query = "SELECT b.id, c.id AS bChargeId, c.contractChargeId , c.date, b.sum, ch.pt FROM bonus_details_charge b LEFT JOIN  bonus_contract_charge c ON c.id=b.chargeId LEFT JOIN contract_charge ch ON ch.id=c.contractChargeId WHERE b.paymentId= " + paymentId + " GROUP BY c.id";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(new BonusDetailCharge(rs.getInt("id"), rs.getInt("bChargeId"), rs.getInt("pt"), (Date)rs.getDate("date"), rs.getBigDecimal("sum"), rs.getInt("contractChargeId")));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public void deleteDeatails(int id) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM bonus_details_charge WHERE id=" + id);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean isUsePaymentsInDetailsTable(int paymentId) throws Exception {
        boolean result = false;
        String query = "SELECT * FROM bonus_details_charge b WHERE b.paymentId=" + paymentId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = true;
            }
        }
        return result;
    }

    public void addDetailsItem(int chargeId, int paymentId, BigDecimal sum) throws BGException {
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO bonus_details_charge VALUES(0,?,?,?)");){
            ps.setInt(1, chargeId);
            ps.setInt(2, paymentId);
            ps.setBigDecimal(3, sum);
            ps.execute();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateDetailsCharge(int id, int paymentId, BigDecimal sum) throws BGException {
        if (id < 1) {
            return;
        }
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE bonus_details_charge SET paymentId=?, sum=? WHERE id=" + id);
            ps.setInt(1, paymentId);
            ps.setBigDecimal(2, sum);
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public BigDecimal getBalance(int cid, Date date) throws BGException {
        return this.getBalance(cid, date, null, false);
    }

    public BigDecimal getBalance(int cid, Date date, Integer chargeId, boolean withFutureCharge) throws BGException {
        BigDecimal balance = BigDecimal.ZERO;
        try {
            ResultSet rs;
            StringBuilder query = new StringBuilder("SELECT SUM(res.residue) as result FROM (SELECT p.sum-IFNULL(SUM(c.sum),0) as residue FROM (");
            if (flagBalanceCanBeNegative) {
                query.append("SELECT -1 AS id, 0 AS sum UNION ALL ");
            }
            query.append("SELECT p.id, p.sum FROM bonus_contract_payment p WHERE p.cid=? AND p.dateFrom<=? AND p.dateTo>=?) p ");
            query.append("LEFT JOIN (SELECT d.sum,d.paymentId FROM bonus_contract_charge ch LEFT JOIN bonus_details_charge d ON d.chargeId=ch.id WHERE ch.cid=? ");
            if (!withFutureCharge) {
                query.append(" AND ch.date<=? ");
            }
            if (chargeId != null) {
                query.append(" AND ch.id <> " + chargeId + " ");
            }
            query.append(") c ON c.paymentId=p.id GROUP BY p.id) res");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)date));
            ps.setInt(4, cid);
            if (!withFutureCharge) {
                ps.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)date));
            }
            if ((rs = ps.executeQuery()).next()) {
                balance = rs.getBigDecimal("result") == null ? BigDecimal.ZERO : rs.getBigDecimal("result");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return balance;
    }

    public BigDecimal getNotActiveBalanceStill(int cid, Date date) throws BGException {
        BigDecimal balance = new BigDecimal(0);
        if (flagBalanceCanBeNegative) {
            StringBuilder query = new StringBuilder("SELECT SUM(res.residue) as result FROM (SELECT p.sum-IFNULL(SUM(c.sum),0) as residue FROM (");
            query.append("SELECT p.id, p.sum FROM bonus_contract_payment p WHERE p.cid=? AND p.dateFrom>? ) p ");
            query.append("LEFT JOIN (SELECT d.sum,d.paymentId FROM bonus_contract_charge ch LEFT JOIN bonus_details_charge d ON d.chargeId=ch.id WHERE ch.cid=? ");
            query.append(") c ON c.paymentId=p.id GROUP BY p.id) res");
            try {
                PreparedStatement ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)date));
                ps.setInt(3, cid);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    balance = rs.getBigDecimal("result") == null ? BigDecimal.ZERO : rs.getBigDecimal("result");
                }
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SUM(p.sum) as futureBalance FROM bonus_contract_payment p WHERE p.cid=? AND p.dateFrom>?");){
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                balance = rs.getBigDecimal("futureBalance") == null ? BigDecimal.ZERO : rs.getBigDecimal("futureBalance");
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return balance;
    }

    public boolean pluginInclude(int cid) throws BGException {
        boolean turnOn = false;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM bonus_contract_include WHERE cid=?");){
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                turnOn = rs.getInt("include") == pluginTurnOn;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return turnOn;
    }

    public void updatePluginInclude(int contractId, boolean include) throws BGException {
        try {
            boolean addBefore = false;
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM bonus_contract_include WHERE cid=?");
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                addBefore = true;
            }
            rs.close();
            ps.close();
            if (addBefore && !include) {
                ps = this.con.prepareStatement("DELETE FROM bonus_contract_include WHERE cid=" + contractId);
                ps.executeUpdate();
                ps.close();
            } else if (include && !addBefore) {
                ps = this.con.prepareStatement("INSERT INTO bonus_contract_include VALUES (?,?)");
                ps.setInt(1, contractId);
                ps.setInt(2, pluginTurnOn);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateProgram(BonusProgram program) throws BGException {
        StringBuilder params = new StringBuilder();
        for (String key : program.getParams().keySet()) {
            params.append(key + "=" + (String)program.getParams().get(key) + "\r\n");
        }
        Period period = program.getPeriod();
        StringBuilder query = new StringBuilder("INSERT INTO bonus_programs VALUES(?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE title=?,typeId=?,dateFrom=?,dateTo=?,paymentTypeId=?,timeLag=?,activeTime=?,params=?");
        int index = 1;
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(index++, program.getId());
            ps.setString(index++, program.getTitle());
            ps.setInt(index++, program.getProgramTypeId());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.setInt(index++, program.getPaymentTypeId());
            ps.setString(index++, program.getTimeLag());
            ps.setString(index++, program.getActiveTime());
            ps.setString(index++, params.toString());
            ps.setString(index++, program.getTitle());
            ps.setInt(index++, program.getProgramTypeId());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.setInt(index++, program.getPaymentTypeId());
            ps.setString(index++, program.getTimeLag());
            ps.setString(index++, program.getActiveTime());
            ps.setString(index++, params.toString());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public boolean checkProgramPeriodOnCrossing(BonusProgram program) throws BGException {
        boolean result = true;
        if (program != null && program.getPeriod() != null && program.getPeriod().getDateFrom() != null) {
            if (program.getId() > 0) {
                StringBuilder query = new StringBuilder("SELECT * FROM bonus_contract_program WHERE programId=? AND ( dateFrom<? OR dateTo>? )");
                try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                    ps.setInt(1, program.getId());
                    ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)program.getPeriod().getDateFrom()));
                    ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)program.getPeriod().getDateTo()));
                    ResultSet rs = ps.executeQuery();
                    result = rs.next();
                }
                catch (SQLException e) {
                    throw new BGException((Throwable)e);
                }
            }
            result = false;
        }
        return result;
    }

    public BonusProgram getProgram(int id) throws Exception {
        BonusProgram program = null;
        String query = "SELECT * FROM bonus_programs WHERE id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                program = this.getBonusProgramFromResultSet(rs);
            }
        }
        return program;
    }

    public List<BonusProgram> getProgramList(Date date, int programTypeId) throws Exception {
        ArrayList<BonusProgram> bonusProgramList = new ArrayList<BonusProgram>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM bonus_programs");
            if (programTypeId > 0) {
                query.append(" WHERE typeId=?");
            }
            if (date != null) {
                if (programTypeId > 0) {
                    query.append(" AND dateFrom<=? AND ( dateTo is NULL OR dateTo>=?)");
                } else {
                    query.append(" WHERE dateFrom<=? AND ( dateTo is NULL OR dateTo>=?)");
                }
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int index = 1;
            if (programTypeId > 0) {
                ps.setInt(index++, programTypeId);
            }
            if (date != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                bonusProgramList.add(this.getBonusProgramFromResultSet(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return bonusProgramList;
    }

    public List<BonusContractProgram> getProgramCotractList(int cid) throws Exception {
        ArrayList<BonusContractProgram> programContractList = new ArrayList<BonusContractProgram>();
        String query = "SELECT * FROM bonus_contract_program WHERE cid=" + cid;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                programContractList.add(new BonusContractProgram(cid, this.getProgram(rs.getInt("programId")), new Period((Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo"))));
            }
        }
        return programContractList;
    }

    public List<BonusContractProgram> getProgramCotractList(int cid, int programTypeId, Date date) throws Exception {
        ArrayList<BonusContractProgram> programContractList = new ArrayList<BonusContractProgram>();
        if (cid < 1) {
            return programContractList;
        }
        StringBuilder query = new StringBuilder("SELECT bc.* FROM bonus_contract_program AS bc LEFT JOIN bonus_programs AS bp ON bc.programId=bp.id WHERE cid=" + cid);
        if (programTypeId > 0) {
            query.append(" AND bp.typeId=" + programTypeId);
        }
        if (date != null) {
            query.append(" AND bc.dateFrom<=? AND ( bc.dateTo is NULL OR bc.dateTo>=?)");
            query.append(" AND bp.dateFrom<=? AND ( bp.dateTo is NULL OR bp.dateTo>=?)");
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (date != null) {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)date));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    programContractList.add(new BonusContractProgram(cid, this.getProgram(rs.getInt("programId")), new Period((Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo"))));
                }
            }
        }
        return programContractList;
    }

    public void updateProgramContract(BonusContractProgram contractProgram) throws BGException {
        if (contractProgram.getContractId() < 1 || contractProgram.getPeriod() == null || contractProgram.getPeriod().getDateFrom() == null || contractProgram.getProgram() == null || contractProgram.getProgram().getId() < 1) {
            return;
        }
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO bonus_contract_program SET cid=?, programId=?, dateFrom=?, dateTo=? ON DUPLICATE KEY UPDATE dateFrom=?, dateTo=?");){
            ps.setInt(1, contractProgram.getContractId());
            ps.setInt(2, contractProgram.getProgram().getId());
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)contractProgram.getPeriod().getDateFrom()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)contractProgram.getPeriod().getDateTo()));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)contractProgram.getPeriod().getDateFrom()));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)contractProgram.getPeriod().getDateTo()));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Deprecated
    public List<Integer> programInContractList(int idProgram, Date date) throws BGException {
        return this.getContractsOfThisProgram(idProgram, date);
    }

    public List<Integer> getContractsOfThisProgram(int idProgram, Date date) throws BGException {
        ArrayList<Integer> contractList = new ArrayList<Integer>();
        try {
            PreparedStatement ps;
            StringBuilder query = new StringBuilder();
            if (date == null) {
                query.append("SELECT * FROM bonus_contract_program WHERE programId=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, idProgram);
            } else {
                query.append("SELECT * FROM bonus_contract_program WHERE programId=? AND dateFrom<=? AND ( dateTo IS NULL OR dateTo>=?)");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, idProgram);
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                contractList.add(rs.getInt("cid"));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return contractList;
    }

    public boolean checkContractOnProgramType(int cid, int programType, Date date) throws BGException {
        boolean result = false;
        StringBuilder query = new StringBuilder("SELECT COUNT(*) AS count FROM bonus_contract_program AS c LEFT JOIN bonus_programs p ON c.programId=p.id WHERE c.cid=? AND p.typeId=? AND c.dateFrom<=? AND ( c.dateTo IS NULL OR c.dateTo>=?)");
        query.append("AND p.dateFrom<=? AND ( p.dateTo IS NULL OR p.dateTo>=?)");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, cid);
            ps.setInt(2, programType);
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)date));
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getInt("count") > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void deleteProgram(int programId) throws BGException {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM bonus_programs WHERE id=" + programId);
            st.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public BonusProgramSpecification getProgramAction(BonusProgram bonusProgram) throws Exception {
        OperationBonusProgram result = null;
        if (bonusProgram.getProgramTypeId() == 1) {
            result = new OperationBonusProgram();
        } else if (bonusProgram.getProgramTypeId() == 2) {
            result = this.getProgramSpecificationForDynamicProgram(bonusProgram.getNameForDynamicClass());
        }
        return result;
    }

    public BonusProgramSpecification getProgramSpecificationForDynamicProgram(String className) throws Exception {
        if (Utils.isBlankString((String)className)) {
            return null;
        }
        BonusProgramSpecification result = null;
        Class clazz = DynamicClassManager.getInstance().loadClass(className);
        if (BonusProgramSpecification.class.isAssignableFrom(clazz)) {
            result = (BonusProgramSpecification)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return result;
    }

    public void updateDataProgramOfContract(int programId, int contractId, Map<String, String> map) throws SQLException {
        if (programId < 1 || contractId < 1 || map == null) {
            return;
        }
        StringBuilder data = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            data.append(data.length() > 0 ? "," : "").append(entry.getKey() + "=" + entry.getValue());
        }
        String dataStr = data.toString();
        String query = "INSERT INTO bonus_program_data_contract VALUES ( ?, ?, ? ) ON DUPLICATE KEY UPDATE programId=?, contractId=?, data=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, programId);
            ps.setInt(index++, contractId);
            ps.setString(index++, dataStr);
            ps.setInt(index++, programId);
            ps.setInt(index++, contractId);
            ps.setString(index++, dataStr);
            ps.executeUpdate();
        }
    }

    public Map<String, String> getDataProgramOfContract(int programId, int contractId) throws BGException {
        HashMap<String, String> map = new HashMap<String, String>();
        String query = "SELECT data FROM bonus_program_data_contract WHERE programId=? AND contractId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, programId);
            ps.setInt(2, contractId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    for (String str : Utils.toList((String)rs.getString(1))) {
                        String[] mas = str.split("=");
                        if (mas.length <= 1) continue;
                        map.put(mas[0], mas[1]);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return map;
    }

    private BonusProgram getBonusProgramFromResultSet(ResultSet resultSet) throws Exception {
        BonusProgram bonusProgram = new BonusProgram();
        bonusProgram.setId(resultSet.getInt("id"));
        bonusProgram.setTitle(resultSet.getString("title"));
        bonusProgram.setProgramTypeId(resultSet.getInt("typeId"));
        bonusProgram.setPeriod(new Period((Date)resultSet.getDate("dateFrom"), (Date)resultSet.getDate("dateTo")));
        bonusProgram.setPaymentTypeId(resultSet.getInt("paymentTypeId"));
        bonusProgram.setTimeLag(resultSet.getString("timeLag"));
        bonusProgram.setActiveTime(resultSet.getString("activeTime"));
        StringTokenizer st = new StringTokenizer(resultSet.getString("params"), "\r\n");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        while (st.hasMoreTokens()) {
            String keyValue = st.nextToken();
            if (!keyValue.contains("=")) continue;
            String[] values = keyValue.split("=");
            paramsMap.put(values[0], values[1]);
        }
        bonusProgram.setParams(paramsMap);
        BonusProgramSpecification specification = this.getProgramAction(bonusProgram);
        bonusProgram.setSpecificationTitle(specification != null ? this.getProgramAction(bonusProgram).getTitle() : "\u041e\u0448\u0438\u0431\u043a\u0430, \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430.");
        return bonusProgram;
    }

    private BonusCharge getBonusChargeFromRS(ResultSet rs) throws SQLException {
        return new BonusCharge(rs.getInt("id"), (Date)rs.getTimestamp("date"), rs.getInt("pt"), rs.getBigDecimal("sum"), rs.getInt("contractChargeId"));
    }

    private BonusPayment getBonusPaymentFromRSWhithName(ResultSet rs) throws SQLException {
        BonusPayment payment = this.getBonusPaymentFromRS(rs);
        payment.setTypeTitle(rs.getString("name"));
        return payment;
    }

    private BonusPayment getBonusPaymentFromRS(ResultSet rs) throws SQLException {
        BonusPayment payment = new BonusPayment(rs.getInt("id"), rs.getInt("typeId"), (Date)rs.getTimestamp("date"), rs.getBigDecimal("sum"), (Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo"));
        payment.setComment(rs.getString("comment"));
        return payment;
    }

    static {
        boolean _flagBonus = false;
        try {
            Map pluginsMap = BGPluginManagerServer.getManager().getPluginsMap();
            Preferences setup = ((BGPluginServer)pluginsMap.get("ru.bitel.bgbilling.plugins.bonus")).getSetup();
            _flagBonus = setup.getBoolean("balance.negative", false);
        }
        catch (Throwable ex) {
            BGLogger.error((Throwable)ex);
        }
        flagBalanceCanBeNegative = _flagBonus;
    }
}

