/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractDao;
import ru.bitel.bgbilling.kernel.contract.script.common.bean.ContractScriptLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ContractScriptLogDao
extends AbstractDao<ContractScriptLog> {
    public ContractScriptLogDao(Connection con, String tableName) {
        super(con, tableName, 0);
    }

    public List<String> getScriptLogTitleList(int contractId, Period period) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        if (ServerUtils.tableExists(this.con, this.tableName)) {
            String query = "SELECT DISTINCT title FROM " + this.tableName + " WHERE cid=" + contractId + " AND TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateFrom()) + (String)(period.getDateTo() != null ? "') AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateTo()) : "") + "') ORDER BY time ";
            try (PreparedStatement ps = this.con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        return result;
    }

    public List<ContractScriptLog> getScriptLogList(int contractId, Period period) throws SQLException {
        return this.getScriptLogList(contractId, period, null, null);
    }

    public List<ContractScriptLog> getScriptLogList(int contractId, Period period, String title, Page page) throws SQLException {
        ArrayList<ContractScriptLog> result = new ArrayList<ContractScriptLog>();
        if (period == null || period.getDateFrom() == null) {
            return result;
        }
        if (ServerUtils.tableExists(this.con, this.tableName)) {
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE cid=" + contractId + " AND TO_DAYS(time)>=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateFrom()) + "')";
            if (period.getDateTo() != null) {
                query = query + " AND TO_DAYS(time)<=TO_DAYS('" + TimeUtils.formatSQLDate((Date)period.getDateTo()) + "')";
            }
            query = query + (title != null ? " AND title=?" : "");
            query = query + " ORDER BY time DESC ";
            query = query + this.sqlLimit(page);
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                if (title != null) {
                    ps.setString(1, title);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result.add(this.getFromRS(rs));
                    }
                }
                if (page != null && page.getPageSize() > 0) {
                    page.setRecordCount(ServerUtils.foundRows(this.con));
                }
            }
        }
        return result;
    }

    protected void updateImpl(ContractScriptLog b) throws SQLException {
    }

    protected ContractScriptLog getFromRS(ResultSet rs) throws SQLException {
        return ContractScriptLog.builder().setContractId(rs.getInt("cid")).setDate(rs.getTimestamp("time")).setTitle(rs.getString("title")).setData(rs.getString("data")).build();
    }
}

